/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.select.selector;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialectFactory;
import com.alibaba.otter.node.etl.common.db.dialect.mysql.MysqlDialect;
import com.alibaba.otter.node.etl.common.db.dialect.oracle.OracleDialect;
import com.alibaba.otter.node.etl.select.exceptions.SelectException;
import com.alibaba.otter.node.etl.transform.exception.TransformException;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.channel.ChannelParameter;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.model.config.pipeline.PipelineParameter;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventColumnIndexComparable;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class MessageParser {
    private static final Logger logger = LoggerFactory.getLogger(MessageParser.class);
    private ConfigClientService configClientService;
    private DbDialectFactory dbDialectFactory;
    private static final String RETL_CLIENT_FLAG = "_SYNC";
    private static final String compatibleMarkTable = "retl_client";
    private static final String compatibleMarkInfoColumn = "client_info";
    private static final String compatibleMarkIdentifierColumn = "client_identifier";

    public List<EventData> parse(Long pipelineId, List<CanalEntry.Entry> datas) throws SelectException {
        ArrayList<EventData> eventDatas = new ArrayList<EventData>();
        Pipeline pipeline = this.configClientService.findPipeline(pipelineId);
        ArrayList<CanalEntry.Entry> transactionDataBuffer = new ArrayList<CanalEntry.Entry>();
        PipelineParameter pipelineParameter = pipeline.getParameters();
        boolean enableLoopbackRemedy = pipelineParameter.isEnableRemedy() != false && pipelineParameter.isHome() != false && pipelineParameter.getRemedyAlgorithm().isLoopback();
        boolean isLoopback = false;
        boolean needLoopback = false;
        long now = new Date().getTime();
        try {
            for (CanalEntry.Entry entry : datas) {
                switch (entry.getEntryType()) {
                    case TRANSACTIONBEGIN: {
                        isLoopback = false;
                        break;
                    }
                    case ROWDATA: {
                        CanalEntry.RowChange rowChange;
                        boolean isCompatibleLoopback;
                        CanalEntry.RowChange rowChange2;
                        String tableName = entry.getHeader().getTableName();
                        boolean isMarkTable = tableName.equalsIgnoreCase(pipeline.getParameters().getSystemMarkTable());
                        if (isMarkTable && !(rowChange2 = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue())).getIsDdl()) {
                            int loopback = 0;
                            if (rowChange2.getRowDatasCount() > 0) {
                                loopback = this.checkLoopback(pipeline, rowChange2.getRowDatas(0));
                            }
                            if (loopback == 2) {
                                needLoopback |= true;
                            }
                            isLoopback |= loopback > 0;
                        }
                        if ((isCompatibleLoopback = tableName.equalsIgnoreCase(compatibleMarkTable)) && !(rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue())).getIsDdl()) {
                            int loopback = 0;
                            if (rowChange.getRowDatasCount() > 0) {
                                loopback = this.checkCompatibleLoopback(pipeline, rowChange.getRowDatas(0));
                            }
                            if (loopback == 2) {
                                needLoopback |= true;
                            }
                            isLoopback |= loopback > 0;
                        }
                        if (isLoopback && (!enableLoopbackRemedy || !needLoopback) || isMarkTable || isCompatibleLoopback) break;
                        transactionDataBuffer.add(entry);
                        break;
                    }
                    case TRANSACTIONEND: {
                        if (!isLoopback || enableLoopbackRemedy && needLoopback) {
                            for (CanalEntry.Entry bufferEntry : transactionDataBuffer) {
                                List<EventData> parseDatas = this.internParse(pipeline, bufferEntry);
                                if (CollectionUtils.isEmpty(parseDatas)) continue;
                                long totalSize = bufferEntry.getHeader().getEventLength();
                                long eachSize = totalSize / (long)parseDatas.size();
                                for (EventData eventData : parseDatas) {
                                    if (eventData == null) continue;
                                    eventData.setSize(eachSize);
                                    if (needLoopback) {
                                        if (now - eventData.getExecuteTime() > (long)(1000 * pipeline.getParameters().getRemedyDelayThresoldForMedia())) {
                                            eventData.setSyncConsistency(ChannelParameter.SyncConsistency.MEDIA);
                                        } else {
                                            eventData.setSyncConsistency(ChannelParameter.SyncConsistency.BASE);
                                        }
                                        eventData.setRemedy(true);
                                    }
                                    eventDatas.add(eventData);
                                }
                            }
                        }
                        isLoopback = false;
                        needLoopback = false;
                        transactionDataBuffer.clear();
                        break;
                    }
                }
            }
            if (!isLoopback || enableLoopbackRemedy && needLoopback) {
                for (CanalEntry.Entry bufferEntry : transactionDataBuffer) {
                    List<EventData> parseDatas = this.internParse(pipeline, bufferEntry);
                    if (CollectionUtils.isEmpty(parseDatas)) continue;
                    long totalSize = bufferEntry.getHeader().getEventLength();
                    long eachSize = totalSize / (long)parseDatas.size();
                    for (EventData eventData : parseDatas) {
                        if (eventData == null) continue;
                        eventData.setSize(eachSize);
                        if (needLoopback) {
                            if (now - eventData.getExecuteTime() > (long)(1000 * pipeline.getParameters().getRemedyDelayThresoldForMedia())) {
                                eventData.setSyncConsistency(ChannelParameter.SyncConsistency.MEDIA);
                            } else {
                                eventData.setSyncConsistency(ChannelParameter.SyncConsistency.BASE);
                            }
                        }
                        eventDatas.add(eventData);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SelectException(e);
        }
        return eventDatas;
    }

    private int checkLoopback(Pipeline pipeline, CanalEntry.RowData rowData) {
        CanalEntry.Column infokColumn = this.getColumnIgnoreCase(rowData.getAfterColumnsList(), pipeline.getParameters().getSystemMarkTableInfo());
        if (infokColumn != null && StringUtils.endsWithIgnoreCase((String)infokColumn.getValue(), (String)RETL_CLIENT_FLAG)) {
            return 1;
        }
        if (infokColumn != null && StringUtils.equalsIgnoreCase((String)infokColumn.getValue(), (String)pipeline.getParameters().getChannelInfo())) {
            return 2;
        }
        infokColumn = this.getColumnIgnoreCase(rowData.getBeforeColumnsList(), pipeline.getParameters().getSystemMarkTableInfo());
        if (infokColumn != null && StringUtils.endsWithIgnoreCase((String)infokColumn.getValue(), (String)RETL_CLIENT_FLAG)) {
            return 1;
        }
        if (infokColumn != null && StringUtils.equalsIgnoreCase((String)infokColumn.getValue(), (String)pipeline.getParameters().getChannelInfo())) {
            return 2;
        }
        CanalEntry.Column markColumn = this.getColumnIgnoreCase(rowData.getAfterColumnsList(), pipeline.getParameters().getSystemMarkTableColumn());
        if (markColumn != null && pipeline.getChannelId().equals(Long.parseLong(markColumn.getValue()))) {
            return 2;
        }
        markColumn = this.getColumnIgnoreCase(rowData.getBeforeColumnsList(), pipeline.getParameters().getSystemMarkTableColumn());
        if (markColumn != null && pipeline.getChannelId().equals(Long.parseLong(markColumn.getValue()))) {
            return 2;
        }
        return 0;
    }

    private int checkCompatibleLoopback(Pipeline pipeline, CanalEntry.RowData rowData) {
        CanalEntry.Column infokColumn = this.getColumnIgnoreCase(rowData.getAfterColumnsList(), compatibleMarkInfoColumn);
        if (infokColumn != null && infokColumn.getValue().toUpperCase().endsWith(RETL_CLIENT_FLAG)) {
            return 1;
        }
        infokColumn = this.getColumnIgnoreCase(rowData.getBeforeColumnsList(), compatibleMarkInfoColumn);
        if (infokColumn != null && infokColumn.getValue().toUpperCase().endsWith(RETL_CLIENT_FLAG)) {
            return 1;
        }
        CanalEntry.Column markColumn = this.getColumnIgnoreCase(rowData.getAfterColumnsList(), compatibleMarkIdentifierColumn);
        if (markColumn != null && pipeline.getChannelId().equals(Long.parseLong(markColumn.getValue()))) {
            return 2;
        }
        markColumn = this.getColumnIgnoreCase(rowData.getBeforeColumnsList(), compatibleMarkIdentifierColumn);
        if (markColumn != null && pipeline.getChannelId().equals(Long.parseLong(markColumn.getValue()))) {
            return 2;
        }
        return 0;
    }

    private CanalEntry.Column getColumnIgnoreCase(List<CanalEntry.Column> columns, String columName) {
        for (CanalEntry.Column column : columns) {
            if (!column.getName().equalsIgnoreCase(columName)) continue;
            return column;
        }
        return null;
    }

    private List<EventData> internParse(Pipeline pipeline, CanalEntry.Entry entry) {
        CanalEntry.RowChange rowChange = null;
        try {
            rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
        }
        catch (Exception e) {
            throw new SelectException("parser of canal-event has an error , data:" + entry.toString(), e);
        }
        if (rowChange == null) {
            return null;
        }
        String schemaName = entry.getHeader().getSchemaName();
        String tableName = entry.getHeader().getTableName();
        EventType eventType = EventType.valueOf((String)rowChange.getEventType().name());
        if (eventType.isQuery()) {
            return null;
        }
        if (StringUtils.equalsIgnoreCase((String)pipeline.getParameters().getSystemSchema(), (String)schemaName)) {
            if (eventType.isDdl()) {
                return null;
            }
            if (StringUtils.equalsIgnoreCase((String)pipeline.getParameters().getSystemDualTable(), (String)tableName)) {
                return null;
            }
        } else if (eventType.isDdl()) {
            boolean ddlSync;
            DataMedia dataMedia;
            boolean notExistReturnNull = false;
            if (eventType.isRename()) {
                notExistReturnNull = true;
            }
            if ((dataMedia = ConfigHelper.findSourceDataMedia((Pipeline)pipeline, (String)schemaName, (String)tableName, (boolean)notExistReturnNull)) != null && (eventType.isCreate() || eventType.isAlter() || eventType.isRename())) {
                DbDialect dbDialect = this.dbDialectFactory.getDbDialect(pipeline.getId(), (DbMediaSource)dataMedia.getSource());
                dbDialect.reloadTable(schemaName, tableName);
            }
            if (ddlSync = pipeline.getParameters().getDdlSync().booleanValue()) {
                EventData eventData = new EventData();
                eventData.setSchemaName(schemaName);
                eventData.setTableName(tableName);
                eventData.setEventType(eventType);
                eventData.setExecuteTime(entry.getHeader().getExecuteTime());
                eventData.setSql(rowChange.getSql());
                eventData.setDdlSchemaName(rowChange.getDdlSchemaName());
                eventData.setTableId(dataMedia.getId().longValue());
                return Arrays.asList(eventData);
            }
            return null;
        }
        ArrayList<EventData> eventDatas = new ArrayList<EventData>();
        for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
            EventData eventData = this.internParse(pipeline, entry, rowChange, rowData);
            if (eventData == null) continue;
            eventDatas.add(eventData);
        }
        return eventDatas;
    }

    private EventData internParse(Pipeline pipeline, CanalEntry.Entry entry, CanalEntry.RowChange rowChange, CanalEntry.RowData rowData) {
        EventData eventData = new EventData();
        eventData.setTableName(entry.getHeader().getTableName());
        eventData.setSchemaName(entry.getHeader().getSchemaName());
        eventData.setEventType(EventType.valueOf((String)rowChange.getEventType().name()));
        eventData.setExecuteTime(entry.getHeader().getExecuteTime());
        EventType eventType = eventData.getEventType();
        TableInfoHolder tableHolder = null;
        if (!StringUtils.equalsIgnoreCase((String)pipeline.getParameters().getSystemSchema(), (String)eventData.getSchemaName())) {
            boolean useTableTransform = pipeline.getParameters().getUseTableTransform();
            Table table = null;
            DataMediaPair dataMediaPair = ConfigHelper.findDataMediaPairBySourceName((Pipeline)pipeline, (String)eventData.getSchemaName(), (String)eventData.getTableName());
            DataMedia dataMedia = dataMediaPair.getSource();
            eventData.setTableId(dataMedia.getId().longValue());
            DataMedia targetDataMedia = dataMediaPair.getTarget();
            if (useTableTransform || dataMedia.getSource().getType().isOracle()) {
                String tableName;
                Object schemaName;
                String shardColumns;
                DbDialect targetDbDialect;
                DataMediaSource targetSource;
                DbDialect dbDialect = this.dbDialectFactory.getDbDialect(pipeline.getId(), (DbMediaSource)dataMedia.getSource());
                table = dbDialect.findTable(eventData.getSchemaName(), eventData.getTableName());
                if (table == null) {
                    logger.warn("find table[{}.{}] is null , may be drop table.", (Object)eventData.getSchemaName(), (Object)eventData.getTableName());
                }
                if ((targetSource = targetDataMedia.getSource()) instanceof DbMediaSource && StringUtils.containsIgnoreCase((String)((DbMediaSource)targetSource).getUrl(), (String)"drds") && (targetDbDialect = this.dbDialectFactory.getDbDialect(pipeline.getId(), (DbMediaSource)targetDataMedia.getSource())).isDRDS() && StringUtils.isNotEmpty((String)(shardColumns = targetDbDialect.getShardColumns((String)(schemaName = this.buildName(eventData.getSchemaName(), dataMedia.getNamespaceMode(), targetDataMedia.getNamespaceMode())), tableName = this.buildName(eventData.getSchemaName(), dataMedia.getNameMode(), targetDataMedia.getNameMode()))))) {
                    String[] columns;
                    for (String key : columns = StringUtils.split((String)shardColumns, (char)',')) {
                        Column col = table.findColumn(key, false);
                        if (col != null) {
                            col.setPrimaryKey(true);
                            continue;
                        }
                        logger.warn(String.format("shardColumn %s in table[%s.%s] is not found", key, eventData.getSchemaName(), eventData.getTableName()));
                    }
                }
                tableHolder = new TableInfoHolder(dbDialect, table, useTableTransform);
            }
        }
        List beforeColumns = rowData.getBeforeColumnsList();
        List afterColumns = rowData.getAfterColumnsList();
        String tableName = eventData.getSchemaName() + "." + eventData.getTableName();
        boolean isRowMode = pipeline.getParameters().getSyncMode().isRow();
        boolean needAllColumns = isRowMode || this.checkNeedAllColumns(pipeline);
        LinkedHashMap<String, EventColumn> keyColumns = new LinkedHashMap<String, EventColumn>();
        LinkedHashMap<String, EventColumn> oldKeyColumns = new LinkedHashMap<String, EventColumn>();
        LinkedHashMap<String, EventColumn> notKeyColumns = new LinkedHashMap<String, EventColumn>();
        if (eventType.isInsert()) {
            for (CanalEntry.Column column : afterColumns) {
                if (this.isKey(tableHolder, tableName, column)) {
                    keyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
                    continue;
                }
                notKeyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
            }
        } else if (eventType.isDelete()) {
            for (CanalEntry.Column column : beforeColumns) {
                if (this.isKey(tableHolder, tableName, column)) {
                    keyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
                    continue;
                }
                notKeyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
            }
        } else if (eventType.isUpdate()) {
            for (CanalEntry.Column column : beforeColumns) {
                if (this.isKey(tableHolder, tableName, column)) {
                    oldKeyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
                    keyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
                    continue;
                }
                if (!needAllColumns || entry.getHeader().getSourceType() != CanalEntry.Type.ORACLE) continue;
                notKeyColumns.put(column.getName(), this.copyEventColumn(column, isRowMode, tableHolder));
            }
            for (CanalEntry.Column column : afterColumns) {
                if (this.isKey(tableHolder, tableName, column)) {
                    keyColumns.put(column.getName(), this.copyEventColumn(column, true, tableHolder));
                    continue;
                }
                if (!needAllColumns && entry.getHeader().getSourceType() != CanalEntry.Type.ORACLE && !column.getUpdated()) continue;
                boolean isUpdate = true;
                if (entry.getHeader().getSourceType() == CanalEntry.Type.MYSQL) {
                    isUpdate = column.getUpdated();
                }
                notKeyColumns.put(column.getName(), this.copyEventColumn(column, isRowMode || isUpdate, tableHolder));
            }
            if (entry.getHeader().getSourceType() == CanalEntry.Type.ORACLE) {
                this.checkUpdateKeyColumns(oldKeyColumns, keyColumns);
            }
        }
        ArrayList keys = new ArrayList(keyColumns.values());
        ArrayList oldKeys = new ArrayList(oldKeyColumns.values());
        ArrayList columns = new ArrayList(notKeyColumns.values());
        Collections.sort(keys, new EventColumnIndexComparable());
        Collections.sort(oldKeys, new EventColumnIndexComparable());
        Collections.sort(columns, new EventColumnIndexComparable());
        if (!keyColumns.isEmpty()) {
            eventData.setKeys(keys);
            if (eventData.getEventType().isUpdate() && !oldKeys.equals(keys)) {
                eventData.setOldKeys(oldKeys);
            }
        } else {
            throw new SelectException("this rowdata has no pks , entry: " + entry.toString() + " and rowData: " + rowData);
        }
        eventData.setColumns(columns);
        return eventData;
    }

    private boolean checkNeedAllColumns(Pipeline pipeline) {
        boolean needAllColumns = false;
        for (DataMediaPair pair : pipeline.getPairs()) {
            needAllColumns |= pair.isExistFilter();
            if (pair.getResolverData() != null && pair.getResolverData().getExtensionDataType() != null) {
                if (pair.getResolverData().getExtensionDataType().isClazz()) {
                    needAllColumns |= StringUtils.isNotEmpty((String)pair.getResolverData().getClazzPath());
                    continue;
                }
                needAllColumns |= StringUtils.isNotEmpty((String)pair.getResolverData().getSourceText());
                continue;
            }
            needAllColumns |= Boolean.FALSE.booleanValue();
        }
        return needAllColumns;
    }

    private void checkUpdateKeyColumns(Map<String, EventColumn> oldKeyColumns, Map<String, EventColumn> keyColumns) {
        if (oldKeyColumns.size() == 0) {
            return;
        }
        if (keyColumns.size() > oldKeyColumns.size()) {
            return;
        }
        if (keyColumns.size() == 0) {
            keyColumns.putAll(oldKeyColumns);
            return;
        }
        if (oldKeyColumns.size() != keyColumns.size()) {
            for (String oldKey : oldKeyColumns.keySet()) {
                if (keyColumns.get(oldKey) != null) continue;
                keyColumns.put(oldKey, oldKeyColumns.get(oldKey));
            }
        }
    }

    private EventColumn copyEventColumn(CanalEntry.Column column, boolean isUpdate, TableInfoHolder tableHolder) {
        EventColumn eventColumn = new EventColumn();
        eventColumn.setIndex(column.getIndex());
        eventColumn.setKey(column.getIsKey());
        eventColumn.setNull(column.getIsNull());
        eventColumn.setColumnName(column.getName());
        eventColumn.setColumnValue(column.getValue());
        eventColumn.setUpdate(isUpdate);
        eventColumn.setColumnType(column.getSqlType());
        if (tableHolder != null && tableHolder.getTable() != null && (tableHolder.isUseTableTransform() || tableHolder.isOracle())) {
            int sqlType;
            Column dbColumn = tableHolder.getTable().findColumn(column.getName(), false);
            if (dbColumn == null) {
                tableHolder.reload();
                dbColumn = tableHolder.getTable().findColumn(column.getName(), false);
            }
            if (dbColumn != null && (sqlType = dbColumn.getTypeCode()) != column.getSqlType()) {
                eventColumn.setColumnType(sqlType);
                logger.info("table [{}] column [{}] is not match , MeType: {}, EType {}", new Object[]{tableHolder.getTable().getName(), column.getName(), sqlType, column.getSqlType()});
            }
        }
        return eventColumn;
    }

    private boolean isKey(TableInfoHolder tableHolder, String tableName, CanalEntry.Column column) {
        boolean isMKey;
        boolean isEKey = column.getIsKey();
        if (tableHolder == null || tableHolder.getTable() == null || !tableHolder.isUseTableTransform()) {
            return isEKey;
        }
        Column dbColumn = tableHolder.getTable().findColumn(column.getName(), false);
        if (dbColumn == null) {
            tableHolder.reload();
            dbColumn = tableHolder.getTable().findColumn(column.getName(), false);
            if (dbColumn == null) {
                throw new SelectException(String.format("not found column[%s] in table[%s]", column.getName(), tableHolder.getTable().toVerboseString()));
            }
        }
        if ((isMKey = dbColumn.isPrimaryKey()) != isEKey) {
            logger.info("table [{}] column [{}] is not match , isMeky: {}, isEkey {}", new Object[]{tableName, column.getName(), isMKey, isEKey});
        }
        return isMKey;
    }

    private String buildName(String name, DataMedia.ModeValue sourceModeValue, DataMedia.ModeValue targetModeValue) {
        if (targetModeValue.getMode().isWildCard()) {
            return name;
        }
        if (targetModeValue.getMode().isMulti()) {
            int index = ConfigHelper.indexIgnoreCase((List)sourceModeValue.getMultiValue(), (String)name);
            if (index == -1) {
                throw new TransformException("can not found namespace or name in media:" + sourceModeValue.toString());
            }
            return (String)targetModeValue.getMultiValue().get(index);
        }
        return targetModeValue.getSingleValue();
    }

    public void setDbDialectFactory(DbDialectFactory dbDialectFactory) {
        this.dbDialectFactory = dbDialectFactory;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    static class TableInfoHolder {
        private DbDialect dbDialect;
        private Table table;
        private boolean useTableTransform;

        public TableInfoHolder(DbDialect dbDialect, Table table, boolean useTableTransform) {
            this.dbDialect = dbDialect;
            this.table = table;
            this.useTableTransform = useTableTransform;
        }

        public Table getTable() {
            return this.table;
        }

        public void setTable(Table table) {
            this.table = table;
        }

        public DbDialect getDbDialect() {
            return this.dbDialect;
        }

        public void setDbDialect(DbDialect dbDialect) {
            this.dbDialect = dbDialect;
        }

        public boolean isUseTableTransform() {
            return this.useTableTransform;
        }

        public void setUseTableTransform(boolean useTableTransform) {
            this.useTableTransform = useTableTransform;
        }

        public boolean isOracle() {
            return this.dbDialect != null && this.dbDialect instanceof OracleDialect;
        }

        public boolean isMysql() {
            return this.dbDialect != null && this.dbDialect instanceof MysqlDialect;
        }

        public void reload() {
            if (this.table != null) {
                String schemaName = StringUtils.isEmpty((String)this.table.getCatalog()) ? this.table.getSchema() : this.table.getCatalog();
                this.table = this.dbDialect.findTable(schemaName, this.table.getName(), false);
            }
        }
    }
}

