/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.weight;

import com.alibaba.otter.node.etl.load.loader.weight.WeightBarrier;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class WeightController {
    private AtomicInteger latch;
    private WeightBarrier barrier;
    private BlockingQueue<Long> weights = new PriorityBlockingQueue<Long>();

    public WeightController(int load) {
        this.latch = new AtomicInteger(load);
        this.barrier = new WeightBarrier(Integer.MIN_VALUE);
    }

    public synchronized void start(List<Long> weights) throws InterruptedException {
        Long initWeight;
        for (int i = 0; i < weights.size(); ++i) {
            this.weights.add(weights.get(i));
        }
        int number = this.latch.decrementAndGet();
        if (number == 0 && (initWeight = (Long)this.weights.peek()) != null) {
            this.barrier.single(initWeight);
        }
    }

    public void await(long weight) throws InterruptedException {
        this.barrier.await(weight);
    }

    public void await(long weight, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.barrier.await(weight, timeout, unit);
    }

    public synchronized void single(long weight) throws InterruptedException {
        this.weights.remove(weight);
        Long nextWeight = (Long)this.weights.peek();
        if (nextWeight != null) {
            this.barrier.single(nextWeight);
        }
    }
}

