/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db;

import com.alibaba.otter.node.etl.load.loader.db.context.FileLoadContext;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

public class FileloadDumper {
    private static final String SEP = SystemUtils.LINE_SEPARATOR;
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static String context_format = null;
    private static String miss_format = null;
    private static String filter_format = null;

    public static String dumpContext(String status, FileLoadContext context) {
        int successed = context.getProcessedDatas().size();
        int failed = context.getFailedDatas().size();
        int all = context.getPrepareDatas().size();
        boolean isInterrupt = all != failed + successed;
        Date now = new Date();
        SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_FORMAT);
        return MessageFormat.format(context_format, status, format.format(now), context.getIdentity().toString(), all, successed, failed, isInterrupt, FileloadDumper.dumpFileDatas(context.getProcessedDatas()), FileloadDumper.dumpFileDatas(context.getFailedDatas()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpFileDatas(List<FileData> fileDatas) {
        StringBuilder builder = new StringBuilder();
        List<FileData> list = fileDatas;
        synchronized (list) {
            for (FileData data : fileDatas) {
                builder.append("\t").append(data.toString()).append(SEP);
            }
        }
        return builder.toString();
    }

    public static String dumpMissFileDatas(Identity identity, FileData fileData) {
        return MessageFormat.format(miss_format, identity.toString(), fileData.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpFilterFileDatas(Identity identity, int input, int output, List<FileData> fileDatas) {
        StringBuilder builder = new StringBuilder();
        List<FileData> list = fileDatas;
        synchronized (list) {
            for (FileData data : fileDatas) {
                builder.append("\t").append(data.toString()).append(SEP);
            }
        }
        return MessageFormat.format(filter_format, identity.toString(), input, output, fileDatas.size(), builder.toString());
    }

    static {
        context_format = SEP + "****************************************************" + SEP;
        context_format = "* status : {0}  , time : {1} *" + SEP;
        context_format = context_format + "* Identity : {2} *" + SEP;
        context_format = context_format + "* total Data : [{3}] , success Data : [{4}] , miss Data : [{5}] , Interrupt : [{6}]" + SEP;
        context_format = context_format + "****************************************************" + SEP;
        context_format = context_format + "* process file  *" + SEP;
        context_format = context_format + "{7}" + SEP;
        context_format = context_format + "* miss file *" + SEP;
        context_format = context_format + "{8}" + SEP;
        context_format = context_format + "****************************************************" + SEP;
        miss_format = SEP + "****************************************************" + SEP;
        miss_format = miss_format + "* Identity : {0} *" + SEP;
        miss_format = miss_format + "* miss : " + SEP;
        miss_format = miss_format + "* {1}" + SEP;
        miss_format = miss_format + "****************************************************";
        filter_format = SEP + "****************************************************" + SEP;
        filter_format = filter_format + "* Identity : {0} *" + SEP;
        filter_format = filter_format + "* input [{1}] , output [{2}] , filter [{3}] *" + SEP;
        filter_format = filter_format + "* filters : " + SEP;
        filter_format = filter_format + "* {4}" + SEP;
        filter_format = filter_format + "****************************************************" + SEP;
    }
}

