/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db;

import com.alibaba.otter.node.etl.load.exception.LoadException;
import com.alibaba.otter.shared.arbitrate.impl.setl.monitor.PermitMonitor;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventColumnIndexComparable;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DbLoadMerger {
    private static final Logger logger = LoggerFactory.getLogger(PermitMonitor.class);

    public static List<EventData> merge(List<EventData> eventDatas) {
        LinkedHashMap<RowKey, EventData> result = new LinkedHashMap<RowKey, EventData>();
        for (EventData eventData : eventDatas) {
            DbLoadMerger.merge(eventData, result);
        }
        return new LinkedList<EventData>(result.values());
    }

    public static void merge(EventData eventData, Map<RowKey, EventData> result) {
        EventType eventType = eventData.getEventType();
        switch (eventType) {
            case INSERT: {
                DbLoadMerger.mergeInsert(eventData, result);
                break;
            }
            case UPDATE: {
                DbLoadMerger.mergeUpdate(eventData, result);
                break;
            }
            case DELETE: {
                DbLoadMerger.mergeDelete(eventData, result);
                break;
            }
        }
    }

    private static void mergeInsert(EventData eventData, Map<RowKey, EventData> result) {
        RowKey rowKey = new RowKey(eventData.getTableId(), eventData.getSchemaName(), eventData.getTableName(), eventData.getKeys());
        if (!result.containsKey(rowKey)) {
            result.put(rowKey, eventData);
        } else {
            EventData oldEventData = result.get(rowKey);
            eventData.setSize(oldEventData.getSize() + eventData.getSize());
            if (oldEventData.getEventType() == EventType.DELETE) {
                result.put(rowKey, eventData);
            } else if (oldEventData.getEventType() == EventType.UPDATE || oldEventData.getEventType() == EventType.INSERT) {
                logger.warn("update-insert/insert-insert happend. before[{}] , after[{}]", (Object)oldEventData, (Object)eventData);
                EventData mergeEventData = DbLoadMerger.replaceColumnValue(eventData, oldEventData);
                mergeEventData.getOldKeys().clear();
                result.put(rowKey, mergeEventData);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeUpdate(EventData eventData, Map<RowKey, EventData> result) {
        RowKey rowKey = new RowKey(eventData.getTableId(), eventData.getSchemaName(), eventData.getTableName(), eventData.getKeys());
        if (!CollectionUtils.isEmpty((Collection)eventData.getOldKeys())) {
            RowKey oldKey = new RowKey(eventData.getTableId(), eventData.getSchemaName(), eventData.getTableName(), eventData.getOldKeys());
            if (!result.containsKey(oldKey)) {
                result.put(rowKey, eventData);
                return;
            } else {
                EventData oldEventData = result.get(oldKey);
                eventData.setSize(oldEventData.getSize() + eventData.getSize());
                if (oldEventData.getEventType() == EventType.INSERT) {
                    eventData.setEventType(EventType.INSERT);
                    result.remove(oldKey);
                    EventData mergeEventData = DbLoadMerger.replaceColumnValue(eventData, oldEventData);
                    mergeEventData.getOldKeys().clear();
                    result.put(rowKey, mergeEventData);
                    return;
                } else {
                    if (oldEventData.getEventType() != EventType.UPDATE) throw new LoadException("delete(has old pks) + update impossible happed!");
                    result.remove(oldKey);
                    EventData mergeEventData = DbLoadMerger.replaceColumnValue(eventData, oldEventData);
                    result.put(rowKey, mergeEventData);
                }
            }
            return;
        } else if (!result.containsKey(rowKey)) {
            result.put(rowKey, eventData);
            return;
        } else {
            EventData oldEventData = result.get(rowKey);
            if (oldEventData.getEventType() == EventType.INSERT) {
                eventData.setEventType(EventType.INSERT);
                EventData mergeEventData = DbLoadMerger.replaceColumnValue(eventData, oldEventData);
                result.put(rowKey, mergeEventData);
                return;
            } else if (oldEventData.getEventType() == EventType.UPDATE) {
                EventData mergeEventData = DbLoadMerger.replaceColumnValue(eventData, oldEventData);
                result.put(rowKey, mergeEventData);
                return;
            } else {
                if (oldEventData.getEventType() != EventType.DELETE) return;
                result.put(rowKey, eventData);
            }
        }
    }

    private static void mergeDelete(EventData eventData, Map<RowKey, EventData> result) {
        RowKey rowKey = new RowKey(eventData.getTableId(), eventData.getSchemaName(), eventData.getTableName(), eventData.getKeys());
        if (!result.containsKey(rowKey)) {
            result.put(rowKey, eventData);
        } else {
            EventData oldEventData = result.get(rowKey);
            eventData.setSize(oldEventData.getSize() + eventData.getSize());
            if (!CollectionUtils.isEmpty((Collection)oldEventData.getOldKeys())) {
                eventData.setKeys(oldEventData.getOldKeys());
                eventData.getOldKeys().clear();
                result.remove(rowKey);
                result.put(new RowKey(eventData.getTableId(), eventData.getSchemaName(), eventData.getTableName(), eventData.getKeys()), eventData);
            } else {
                eventData.getOldKeys().clear();
                result.put(rowKey, eventData);
            }
        }
    }

    private static EventData replaceColumnValue(EventData newEventData, EventData oldEventData) {
        List newColumns = newEventData.getColumns();
        List oldColumns = oldEventData.getColumns();
        ArrayList<EventColumn> temp = new ArrayList<EventColumn>();
        for (EventColumn oldColumn : oldColumns) {
            boolean contain = false;
            for (EventColumn newColumn : newColumns) {
                if (!oldColumn.getColumnName().equalsIgnoreCase(newColumn.getColumnName())) continue;
                newColumn.setUpdate(newColumn.isUpdate() || oldColumn.isUpdate());
                contain = true;
            }
            if (contain) continue;
            temp.add(oldColumn);
        }
        newColumns.addAll(temp);
        Collections.sort(newColumns, new EventColumnIndexComparable());
        newEventData.setOldKeys(oldEventData.getOldKeys());
        if (oldEventData.getSyncConsistency() != null) {
            newEventData.setSyncConsistency(oldEventData.getSyncConsistency());
        }
        if (oldEventData.getSyncMode() != null) {
            newEventData.setSyncMode(oldEventData.getSyncMode());
        }
        if (oldEventData.isRemedy()) {
            newEventData.setRemedy(oldEventData.isRemedy());
        }
        newEventData.setSize(oldEventData.getSize() + newEventData.getSize());
        return newEventData;
    }

    public static class RowKey
    implements Serializable {
        private static final long serialVersionUID = -7369951798499581038L;
        private Long tableId;
        private String schemaName;
        private String tableName;
        private List<EventColumn> keys = new ArrayList<EventColumn>();

        public RowKey(Long tableId, String schemaName, String tableName, List<EventColumn> keys) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.keys = keys;
        }

        public RowKey(List<EventColumn> keys) {
            this.keys = keys;
        }

        public List<EventColumn> getKeys() {
            return this.keys;
        }

        public void setKeys(List<EventColumn> keys) {
            this.keys = keys;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public Long getTableId() {
            return this.tableId;
        }

        public void setTableId(Long tableId) {
            this.tableId = tableId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
            result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
            result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RowKey)) {
                return false;
            }
            RowKey other = (RowKey)obj;
            if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
                return false;
            }
            if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
                return false;
            }
            if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
                return false;
            }
            return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
        }
    }
}

