/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db;

import com.alibaba.otter.node.etl.load.loader.db.context.DbLoadContext;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.SystemUtils;
import org.springframework.util.CollectionUtils;

public class DbLoadDumper {
    private static final String SEP = SystemUtils.LINE_SEPARATOR;
    private static String context_format = null;
    private static String eventData_format = null;
    private static int event_default_capacity = 1024;

    public static String dumpContext(DbLoadContext context) {
        int successed = context.getProcessedDatas().size();
        int failed = context.getFailedDatas().size();
        int all = context.getPrepareDatas().size();
        boolean isInterrupt = all != failed + successed;
        return MessageFormat.format(context_format, context.getIdentity().toString(), all, successed, failed, isInterrupt, DbLoadDumper.dumpEventDatas(context.getProcessedDatas()), DbLoadDumper.dumpEventDatas(context.getFailedDatas()));
    }

    public static String dumpEventDatas(List<EventData> eventDatas) {
        if (CollectionUtils.isEmpty(eventDatas)) {
            return "";
        }
        StringBuilder builder = new StringBuilder(event_default_capacity * eventDatas.size());
        for (EventData data : eventDatas) {
            builder.append(DbLoadDumper.dumpEventData(data));
        }
        return builder.toString();
    }

    public static String dumpEventData(EventData eventData) {
        String type = eventData.getEventType() != null ? eventData.getEventType().getValue() : "";
        String consistency = eventData.getSyncConsistency() != null ? eventData.getSyncConsistency().getValue() : "";
        String mode = eventData.getSyncMode() != null ? eventData.getSyncMode().getValue() : "";
        return MessageFormat.format(eventData_format, eventData.getPairId(), eventData.getTableId(), type, String.valueOf(eventData.getExecuteTime()), consistency, mode, DbLoadDumper.dumpEventColumn(eventData.getKeys()), DbLoadDumper.dumpEventColumn(eventData.getOldKeys()), DbLoadDumper.dumpEventColumn(eventData.getColumns()), "\t" + eventData.getSql());
    }

    private static String dumpEventColumn(List<EventColumn> columns) {
        StringBuilder builder = new StringBuilder(event_default_capacity);
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            EventColumn column = columns.get(i);
            builder.append("\t").append(column.toString());
            if (i >= columns.size() - 1) continue;
            builder.append(SEP);
        }
        return builder.toString();
    }

    static {
        context_format = SEP + "****************************************************" + SEP;
        context_format = context_format + "* Identity : {0} *" + SEP;
        context_format = context_format + "* total Data : [{1}] , success Data : [{2}] , failed Data : [{3}] , Interrupt : [{4}]" + SEP;
        context_format = context_format + "****************************************************" + SEP;
        context_format = context_format + "* process Data  *" + SEP;
        context_format = context_format + "{5}" + SEP;
        context_format = context_format + "****************************************************" + SEP;
        context_format = context_format + "* failed Data *" + SEP;
        context_format = context_format + "{6}" + SEP;
        context_format = context_format + "****************************************************" + SEP;
        eventData_format = "-----------------" + SEP;
        eventData_format = eventData_format + "- PairId: {0} , TableId: {1} , EventType : {2} , Time : {3} " + SEP;
        eventData_format = eventData_format + "- Consistency : {4} , Mode : {5} " + SEP;
        eventData_format = eventData_format + "-----------------" + SEP;
        eventData_format = eventData_format + "---Pks" + SEP;
        eventData_format = eventData_format + "{6}" + SEP;
        eventData_format = eventData_format + "---oldPks" + SEP;
        eventData_format = eventData_format + "{7}" + SEP;
        eventData_format = eventData_format + "---Columns" + SEP;
        eventData_format = eventData_format + "{8}" + SEP;
        eventData_format = eventData_format + "---Sql" + SEP;
        eventData_format = eventData_format + "{9}" + SEP;
    }
}

