/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader.db;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.load.exception.LoadException;
import com.alibaba.otter.node.etl.load.loader.LoadContext;
import com.alibaba.otter.node.etl.load.loader.OtterLoader;
import com.alibaba.otter.node.etl.load.loader.db.DbLoadAction;
import com.alibaba.otter.node.etl.load.loader.db.FileLoadAction;
import com.alibaba.otter.node.etl.load.loader.db.context.DbLoadContext;
import com.alibaba.otter.node.etl.load.loader.db.context.FileLoadContext;
import com.alibaba.otter.node.etl.load.loader.interceptor.LoadInterceptor;
import com.alibaba.otter.node.etl.load.loader.weight.WeightController;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.Identity;
import com.alibaba.otter.shared.etl.model.RowBatch;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.CollectionUtils;

public class DataBatchLoader
implements OtterLoader<DbBatch, List<LoadContext>>,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(DataBatchLoader.class);
    private ExecutorService executorService;
    private BeanFactory beanFactory;
    private ConfigClientService configClientService;
    private LoadInterceptor dbInterceptor;

    @Override
    public List<LoadContext> load(DbBatch data) {
        int index;
        RowBatch rowBatch = data.getRowBatch();
        FileBatch fileBatch = data.getFileBatch();
        boolean existFileBatch = rowBatch != null && !CollectionUtils.isEmpty((Collection)fileBatch.getFiles()) && data.getRoot() != null;
        boolean existRowBatch = rowBatch != null && !CollectionUtils.isEmpty((Collection)rowBatch.getDatas());
        int count = 0;
        List<RowBatch> rowBatchs = null;
        if (existRowBatch) {
            rowBatchs = this.split(rowBatch);
            count += rowBatchs.size();
        }
        if (existFileBatch) {
            ++count;
        }
        WeightController controller = new WeightController(count);
        ArrayList<Future> futures = new ArrayList<Future>();
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.executorService);
        if (existFileBatch) {
            this.submitFileBatch(futures, completionService, fileBatch, data.getRoot(), controller);
        }
        if (existRowBatch) {
            this.submitRowBatch(futures, completionService, rowBatchs, controller);
        }
        ArrayList<LoadContext> processedContexts = new ArrayList<LoadContext>();
        LoadException exception = null;
        for (index = 0; index < futures.size(); ++index) {
            try {
                Future future = completionService.take();
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                exception = new LoadException(e);
                break;
            }
            catch (ExecutionException e) {
                exception = new LoadException(e);
                break;
            }
        }
        if (index < futures.size()) {
            for (int errorIndex = 0; errorIndex < futures.size(); ++errorIndex) {
                Future future = (Future)futures.get(errorIndex);
                if (future.isDone()) {
                    try {
                        LoadContext loadContext = (LoadContext)future.get();
                        if (!(loadContext instanceof DbLoadContext)) continue;
                        this.dbInterceptor.error((DbLoadContext)loadContext);
                    }
                    catch (InterruptedException loadContext) {
                    }
                    catch (ExecutionException loadContext) {
                    }
                    catch (Exception e) {
                        logger.error("interceptor process error failed", (Throwable)e);
                    }
                    continue;
                }
                future.cancel(true);
            }
        } else {
            for (int i = 0; i < futures.size(); ++i) {
                Future future = (Future)futures.get(i);
                try {
                    LoadContext loadContext = (LoadContext)future.get();
                    if (!(loadContext instanceof DbLoadContext)) continue;
                    processedContexts.add((DbLoadContext)loadContext);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return processedContexts;
    }

    private void submitFileBatch(List<Future> futures, ExecutorCompletionService completionService, final FileBatch fileBatch, final File rootDir, final WeightController controller) {
        futures.add(completionService.submit(new Callable<FileLoadContext>(){

            @Override
            public FileLoadContext call() throws Exception {
                try {
                    MDC.put((String)"otter", (String)String.valueOf(fileBatch.getIdentity().getPipelineId()));
                    FileLoadAction fileLoadAction = (FileLoadAction)DataBatchLoader.this.beanFactory.getBean("fileLoadAction", FileLoadAction.class);
                    FileLoadContext fileLoadContext = fileLoadAction.load(fileBatch, rootDir, controller);
                    return fileLoadContext;
                }
                finally {
                    MDC.remove((String)"otter");
                }
            }
        }));
    }

    private void submitRowBatch(List<Future> futures, ExecutorCompletionService completionService, List<RowBatch> rowBatchs, final WeightController controller) {
        for (final RowBatch rowBatch : rowBatchs) {
            futures.add(completionService.submit(new Callable<DbLoadContext>(){

                @Override
                public DbLoadContext call() throws Exception {
                    try {
                        MDC.put((String)"otter", (String)String.valueOf(rowBatch.getIdentity().getPipelineId()));
                        DbLoadAction dbLoadAction = (DbLoadAction)DataBatchLoader.this.beanFactory.getBean("dbLoadAction", DbLoadAction.class);
                        DbLoadContext dbLoadContext = dbLoadAction.load(rowBatch, controller);
                        return dbLoadContext;
                    }
                    finally {
                        MDC.remove((String)"otter");
                    }
                }
            }));
        }
    }

    private List<RowBatch> split(RowBatch rowBatch) {
        final Identity identity = rowBatch.getIdentity();
        ConcurrentMap result = OtterMigrateMap.makeComputingMap((Function)new Function<DataMediaSource, RowBatch>(){

            public RowBatch apply(DataMediaSource input) {
                RowBatch rowBatch = new RowBatch();
                rowBatch.setIdentity(identity);
                return rowBatch;
            }
        });
        for (EventData eventData : rowBatch.getDatas()) {
            DataMedia media = ConfigHelper.findDataMedia((Pipeline)this.configClientService.findPipeline(Long.valueOf(identity.getPipelineId())), (Long)eventData.getTableId());
            ((RowBatch)result.get(media.getSource())).merge(eventData);
        }
        return new ArrayList<RowBatch>(result.values());
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setDbInterceptor(LoadInterceptor dbInterceptor) {
        this.dbInterceptor = dbInterceptor;
    }
}

