/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader;

import com.alibaba.otter.node.common.statistics.StatisticsClientService;
import com.alibaba.otter.node.etl.load.loader.LoadContext;
import com.alibaba.otter.node.etl.load.loader.LoadStatsTracker;
import com.alibaba.otter.node.etl.load.loader.db.DataBatchLoader;
import com.alibaba.otter.shared.common.model.statistics.table.TableStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputType;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.Identity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class OtterLoaderFactory {
    private DataBatchLoader dataBatchLoader;
    private LoadStatsTracker loadStatsTracker;
    private StatisticsClientService statisticsClientService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadContext> load(DbBatch dbBatch) {
        try {
            List<LoadContext> list = this.dataBatchLoader.load(dbBatch);
            return list;
        }
        finally {
            try {
                this.sendStat(dbBatch.getRowBatch().getIdentity());
            }
            finally {
                this.loadStatsTracker.removeStat(dbBatch.getRowBatch().getIdentity());
            }
        }
    }

    private void sendStat(Identity identity) {
        LoadStatsTracker.LoadThroughput throughput = this.loadStatsTracker.getStat(identity);
        Collection<LoadStatsTracker.LoadCounter> counters = throughput.getStats();
        Date endTime = new Date();
        long fileSize = 0L;
        long fileCount = 0L;
        long rowSize = 0L;
        long rowCount = 0L;
        long mqSize = 0L;
        long mqCount = 0L;
        ArrayList<TableStat> tableStats = new ArrayList<TableStat>();
        for (LoadStatsTracker.LoadCounter counter : counters) {
            TableStat stat = new TableStat();
            stat.setPipelineId(Long.valueOf(identity.getPipelineId()));
            stat.setDataMediaPairId(counter.getPairId());
            stat.setFileCount(Long.valueOf(counter.getFileCount().longValue()));
            stat.setFileSize(Long.valueOf(counter.getFileSize().longValue()));
            stat.setInsertCount(Long.valueOf(counter.getInsertCount().longValue()));
            stat.setUpdateCount(Long.valueOf(counter.getUpdateCount().longValue()));
            stat.setDeleteCount(Long.valueOf(counter.getDeleteCount().longValue()));
            stat.setStartTime(new Date(throughput.getStartTime()));
            stat.setEndTime(endTime);
            if (!(stat.getFileCount().equals(0L) && stat.getFileSize().equals(0L) && stat.getInsertCount().equals(0L) && stat.getDeleteCount().equals(0L) && stat.getUpdateCount().equals(0L))) {
                tableStats.add(stat);
            }
            fileSize += counter.getFileSize().longValue();
            fileCount += counter.getFileCount().longValue();
            rowSize += counter.getRowSize().longValue();
            rowCount += counter.getRowCount().longValue();
            mqSize += counter.getMqSize().longValue();
            mqCount += counter.getMqCount().longValue();
        }
        if (!CollectionUtils.isEmpty(tableStats)) {
            this.statisticsClientService.sendTableStats(tableStats);
        }
        ArrayList<ThroughputStat> throughputStats = new ArrayList<ThroughputStat>();
        if (rowCount != 0L || rowSize != 0L) {
            ThroughputStat rowThroughputStat = new ThroughputStat();
            rowThroughputStat.setType(ThroughputType.ROW);
            rowThroughputStat.setPipelineId(Long.valueOf(identity.getPipelineId()));
            rowThroughputStat.setNumber(Long.valueOf(rowCount));
            rowThroughputStat.setSize(Long.valueOf(rowSize));
            rowThroughputStat.setStartTime(new Date(throughput.getStartTime()));
            rowThroughputStat.setEndTime(endTime);
            throughputStats.add(rowThroughputStat);
        }
        if (fileCount != 0L || fileSize != 0L) {
            ThroughputStat fileThroughputStat = new ThroughputStat();
            fileThroughputStat.setType(ThroughputType.FILE);
            fileThroughputStat.setPipelineId(Long.valueOf(identity.getPipelineId()));
            fileThroughputStat.setNumber(Long.valueOf(fileCount));
            fileThroughputStat.setSize(Long.valueOf(fileSize));
            fileThroughputStat.setStartTime(new Date(throughput.getStartTime()));
            fileThroughputStat.setEndTime(endTime);
            throughputStats.add(fileThroughputStat);
        }
        if (mqCount != 0L || mqSize != 0L) {
            ThroughputStat mqThroughputStat = new ThroughputStat();
            mqThroughputStat.setType(ThroughputType.MQ);
            mqThroughputStat.setPipelineId(Long.valueOf(identity.getPipelineId()));
            mqThroughputStat.setNumber(Long.valueOf(mqCount));
            mqThroughputStat.setSize(Long.valueOf(mqSize));
            mqThroughputStat.setStartTime(new Date(throughput.getStartTime()));
            mqThroughputStat.setEndTime(endTime);
            throughputStats.add(mqThroughputStat);
        }
        if (!CollectionUtils.isEmpty(throughputStats)) {
            this.statisticsClientService.sendThroughputs(throughputStats);
        }
    }

    public void setStartTime(Identity identity, Long startTime) {
        this.loadStatsTracker.getStat(identity).setStartTime(startTime);
    }

    public void setStatisticsClientService(StatisticsClientService statisticsClientService) {
        this.statisticsClientService = statisticsClientService;
    }

    public void setDataBatchLoader(DataBatchLoader dataBatchLoader) {
        this.dataBatchLoader = dataBatchLoader;
    }

    public void setLoadStatsTracker(LoadStatsTracker loadStatsTracker) {
        this.loadStatsTracker = loadStatsTracker;
    }
}

