/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.load.loader;

import com.alibaba.otter.shared.etl.model.Identity;
import com.google.common.base.Function;
import com.google.common.collect.MigrateMap;
import com.google.common.collect.OtterMigrateMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class LoadStatsTracker {
    private Map<Identity, LoadThroughput> throughputs = OtterMigrateMap.makeComputingMap((Function)new Function<Identity, LoadThroughput>(){

        public LoadThroughput apply(Identity identity) {
            return new LoadThroughput(identity);
        }
    });

    public LoadThroughput getStat(Identity identity) {
        return this.throughputs.get(identity);
    }

    public void removeStat(Identity identity) {
        this.throughputs.remove(identity);
    }

    public static class LoadCounter {
        private Long pairId;
        private AtomicLong fileSize = new AtomicLong(0L);
        private AtomicLong fileCount = new AtomicLong(0L);
        private AtomicLong rowSize = new AtomicLong(0L);
        private AtomicLong rowCount = new AtomicLong(0L);
        private AtomicLong mqCount = new AtomicLong(0L);
        private AtomicLong mqSize = new AtomicLong(0L);
        private AtomicLong deleteCount = new AtomicLong(0L);
        private AtomicLong updateCount = new AtomicLong(0L);
        private AtomicLong insertCount = new AtomicLong(0L);

        public LoadCounter(Long pairId) {
            this.pairId = pairId;
        }

        public Long getPairId() {
            return this.pairId;
        }

        public void setPairId(Long pairId) {
            this.pairId = pairId;
        }

        public AtomicLong getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(AtomicLong fileSize) {
            this.fileSize = fileSize;
        }

        public AtomicLong getFileCount() {
            return this.fileCount;
        }

        public void setFileCount(AtomicLong fileCount) {
            this.fileCount = fileCount;
        }

        public AtomicLong getDeleteCount() {
            return this.deleteCount;
        }

        public void setDeleteCount(AtomicLong deleteCount) {
            this.deleteCount = deleteCount;
        }

        public AtomicLong getUpdateCount() {
            return this.updateCount;
        }

        public void setUpdateCount(AtomicLong updateCount) {
            this.updateCount = updateCount;
        }

        public AtomicLong getInsertCount() {
            return this.insertCount;
        }

        public void setInsertCount(AtomicLong insertCount) {
            this.insertCount = insertCount;
        }

        public AtomicLong getRowSize() {
            return this.rowSize;
        }

        public void setRowSize(AtomicLong rowSize) {
            this.rowSize = rowSize;
        }

        public AtomicLong getRowCount() {
            return this.rowCount;
        }

        public void setRowCount(AtomicLong rowCount) {
            this.rowCount = rowCount;
        }

        public AtomicLong getMqCount() {
            return this.mqCount;
        }

        public void setMqCount(AtomicLong mqCount) {
            this.mqCount = mqCount;
        }

        public AtomicLong getMqSize() {
            return this.mqSize;
        }

        public void setMqSize(AtomicLong mqSize) {
            this.mqSize = mqSize;
        }
    }

    public static class LoadThroughput {
        private Identity identity;
        private Long startTime;
        private Map<Long, LoadCounter> counters = MigrateMap.makeComputingMap((Function)new Function<Long, LoadCounter>(){

            public LoadCounter apply(Long pairId) {
                return new LoadCounter(pairId);
            }
        });

        public LoadThroughput(Identity identity) {
        }

        public LoadCounter getStat(Long pairId) {
            return this.counters.get(pairId);
        }

        public Collection<LoadCounter> getStats() {
            return this.counters.values();
        }

        public Identity getIdentity() {
            return this.identity;
        }

        public void setIdentity(Identity identity) {
            this.identity = identity;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }
    }
}

