/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.extract.extractor;

import com.alibaba.otter.node.etl.extract.exceptions.ExtractException;
import com.alibaba.otter.node.etl.extract.extractor.AbstractExtractor;
import com.alibaba.otter.shared.common.model.config.channel.ChannelParameter;
import com.alibaba.otter.shared.common.model.config.data.ColumnGroup;
import com.alibaba.otter.shared.common.model.config.data.ColumnPair;
import com.alibaba.otter.shared.common.model.config.data.DataMediaPair;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GroupExtractor
extends AbstractExtractor<DbBatch> {
    @Override
    public void extract(DbBatch dbBatch) throws ExtractException {
        Assert.notNull((Object)dbBatch);
        Assert.notNull((Object)dbBatch.getRowBatch());
        Pipeline pipeline = this.getPipeline(dbBatch.getRowBatch().getIdentity().getPipelineId());
        List dataMediaPairs = pipeline.getPairs();
        HashMap<Long, List> groupColumns = new HashMap<Long, List>();
        for (DataMediaPair dataMediaPair : dataMediaPairs) {
            List columnGroups = dataMediaPair.getColumnGroups();
            if (CollectionUtils.isEmpty((Collection)columnGroups)) continue;
            groupColumns.put(dataMediaPair.getSource().getId(), columnGroups);
        }
        List eventDatas = dbBatch.getRowBatch().getDatas();
        for (EventData eventData : eventDatas) {
            List columnGroups;
            if (eventData.getEventType().isDdl() || CollectionUtils.isEmpty((Collection)(columnGroups = (List)groupColumns.get(eventData.getTableId())))) continue;
            for (ColumnGroup columnGroup : columnGroups) {
                if (columnGroup == null || CollectionUtils.isEmpty((Collection)columnGroup.getColumnPairs())) continue;
                this.groupFilter(eventData, columnGroup);
            }
        }
    }

    private void groupFilter(EventData eventData, ColumnGroup columnGroup) {
        ArrayList<EventColumn> addColumns = new ArrayList<EventColumn>();
        HashSet<String> updatedColumns = new HashSet<String>();
        HashSet<String> pks = new HashSet<String>();
        for (EventColumn column : eventData.getUpdatedColumns()) {
            updatedColumns.add(column.getColumnName());
        }
        for (Object pk : eventData.getKeys()) {
            pks.add(pk.getColumnName());
        }
        if (!CollectionUtils.isEmpty((Collection)eventData.getOldKeys())) {
            int i = 0;
            for (EventColumn pk : eventData.getKeys()) {
                if (!StringUtils.equals((String)pk.getColumnValue(), (String)((EventColumn)eventData.getOldKeys().get(i)).getColumnValue())) {
                    updatedColumns.add(pk.getColumnName());
                }
                ++i;
            }
        }
        if (this.containsInGroupColumn(updatedColumns, columnGroup.getColumnPairs())) {
            for (ColumnPair columnPair : columnGroup.getColumnPairs()) {
                String columnName;
                boolean groupColumnHasInChangedColunms = false;
                for (EventColumn column : eventData.getColumns()) {
                    if (!StringUtils.equalsIgnoreCase((String)columnPair.getSourceColumn().getName(), (String)column.getColumnName())) continue;
                    groupColumnHasInChangedColunms = true;
                    if (column.isUpdate()) break;
                    column.setUpdate(true);
                    break;
                }
                if (groupColumnHasInChangedColunms || pks.contains(columnName = columnPair.getSourceColumn().getName())) continue;
                EventColumn addColumn = new EventColumn();
                addColumn.setColumnName(columnPair.getSourceColumn().getName());
                addColumn.setUpdate(true);
                addColumns.add(addColumn);
            }
            if (!CollectionUtils.isEmpty(addColumns)) {
                eventData.getColumns().addAll(addColumns);
                eventData.setSyncConsistency(ChannelParameter.SyncConsistency.MEDIA);
                return;
            }
        }
    }

    private boolean containsInGroupColumn(Set<String> columns, List<ColumnPair> columnPairs) {
        for (ColumnPair columnPair : columnPairs) {
            for (String columnName : columns) {
                if (!StringUtils.equalsIgnoreCase((String)columnPair.getSourceColumn().getName(), (String)columnName)) continue;
                return true;
            }
        }
        return false;
    }
}

