/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.conflict.impl;

import com.alibaba.otter.node.common.communication.NodeCommmunicationClient;
import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.conflict.FileBatchConflictDetectService;
import com.alibaba.otter.node.etl.conflict.model.ConflictEventType;
import com.alibaba.otter.node.etl.conflict.model.FileConflictDetectEvent;
import com.alibaba.otter.node.etl.load.loader.db.FileloadDumper;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.thread.ExecutorTemplate;
import com.alibaba.otter.shared.common.utils.thread.ExecutorTemplateGetter;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.etl.model.EventType;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class FileBatchConflictDetectServiceImpl
implements FileBatchConflictDetectService {
    private static final Logger logger = LoggerFactory.getLogger(FileBatchConflictDetectServiceImpl.class);
    private int retry = 3;
    private ConfigClientService configClientService;
    private NodeCommmunicationClient nodeCommmunicationClient;
    private ExecutorTemplateGetter executorTemplateGetter;

    public FileBatchConflictDetectServiceImpl() {
        CommunicationRegistry.regist((com.alibaba.otter.shared.communication.core.model.EventType)ConflictEventType.fileConflictDetect, (Object)this);
    }

    @Override
    public FileBatch detect(FileBatch fileBatch, Long targetNodeId) {
        FileConflictDetectEvent event = new FileConflictDetectEvent();
        event.setFileBatch(fileBatch);
        if (this.isLocal(targetNodeId)) {
            return this.onFileConflictDetect(event);
        }
        return (FileBatch)this.nodeCommmunicationClient.call(targetNodeId, (Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileBatch onFileConflictDetect(FileConflictDetectEvent event) {
        final FileBatch fileBatch = event.getFileBatch();
        if (CollectionUtils.isEmpty((Collection)fileBatch.getFiles())) {
            return fileBatch;
        }
        ExecutorTemplate executorTemplate = this.executorTemplateGetter.get();
        try {
            MDC.put((String)"load", (String)String.valueOf(fileBatch.getIdentity().getPipelineId()));
            executorTemplate.start();
            Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(fileBatch.getIdentity().getPipelineId()));
            executorTemplate.adjustPoolSize(pipeline.getParameters().getFileLoadPoolSize().intValue());
            final List<FileData> result = Collections.synchronizedList(new ArrayList());
            final List<FileData> filter = Collections.synchronizedList(new ArrayList());
            for (final FileData source : fileBatch.getFiles()) {
                EventType type = source.getEventType();
                if (type.isDelete()) {
                    result.add(source);
                    continue;
                }
                executorTemplate.submit(new Runnable(){

                    @Override
                    public void run() {
                        MDC.put((String)"load", (String)String.valueOf(fileBatch.getIdentity().getPipelineId()));
                        String namespace = source.getNameSpace();
                        String path = source.getPath();
                        FileData target = null;
                        int count = 0;
                        while (count++ < FileBatchConflictDetectServiceImpl.this.retry) {
                            try {
                                if (StringUtils.isBlank((String)namespace)) {
                                    File targetFile = new File(path);
                                    if (targetFile.exists()) {
                                        long lastModified = targetFile.lastModified();
                                        long size = targetFile.length();
                                        target = new FileData();
                                        target.setLastModifiedTime(lastModified);
                                        target.setSize(size);
                                    }
                                    break;
                                }
                                throw new RuntimeException(source + " is not support!");
                            }
                            catch (Exception ex) {
                                target = null;
                            }
                        }
                        boolean shouldSync = false;
                        if (target != null) {
                            if (FileBatchConflictDetectServiceImpl.this.accept(target, source)) {
                                shouldSync = true;
                            }
                        } else {
                            shouldSync = true;
                        }
                        if (shouldSync) {
                            result.add(source);
                        } else {
                            filter.add(source);
                        }
                    }
                });
            }
            executorTemplate.waitForResult();
            if (pipeline.getParameters().getDumpEvent().booleanValue() && logger.isInfoEnabled()) {
                logger.info(FileloadDumper.dumpFilterFileDatas(fileBatch.getIdentity(), fileBatch.getFiles().size(), result.size(), filter));
            }
            FileBatch target = new FileBatch();
            target.setIdentity(fileBatch.getIdentity());
            target.setFiles(result);
            FileBatch fileBatch2 = target;
            return fileBatch2;
        }
        finally {
            if (executorTemplate != null) {
                this.executorTemplateGetter.release(executorTemplate);
            }
            MDC.remove((String)"load");
        }
    }

    private boolean accept(FileData target, FileData source) {
        return target.getLastModifiedTime() < source.getLastModifiedTime() || target.getSize() != source.getSize();
    }

    private boolean isLocal(Long targetNodeId) {
        return this.configClientService.currentNode().getId().equals(targetNodeId);
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setNodeCommmunicationClient(NodeCommmunicationClient nodeCommmunicationClient) {
        this.nodeCommmunicationClient = nodeCommmunicationClient;
    }

    public void setRetry(int retry) {
        this.retry = retry;
    }

    public void setExecutorTemplateGetter(ExecutorTemplateGetter executorTemplateGetter) {
        this.executorTemplateGetter = executorTemplateGetter;
    }
}

