/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.task;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.jmx.StageAggregationCollector;
import com.alibaba.otter.node.etl.common.pipe.impl.RowDataPipeDelegate;
import com.alibaba.otter.shared.arbitrate.ArbitrateEventService;
import com.alibaba.otter.shared.arbitrate.model.TerminEventData;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalTask
extends Thread {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected volatile boolean running = true;
    protected Pipeline pipeline;
    protected Long pipelineId;
    protected ArbitrateEventService arbitrateEventService;
    protected RowDataPipeDelegate rowDataPipeDelegate;
    protected ExecutorService executorService;
    protected ConfigClientService configClientService;
    protected StageAggregationCollector stageAggregationCollector;
    protected Map<Long, Future> pendingFuture;

    public GlobalTask(Pipeline pipeline) {
        this(pipeline.getId());
        this.pipeline = pipeline;
    }

    public GlobalTask(Long pipelineId) {
        this.pipelineId = pipelineId;
        this.setName(this.createTaskName(pipelineId, ClassUtils.getShortClassName(this.getClass())));
        this.pendingFuture = new HashMap<Long, Future>();
    }

    public void shutdown() {
        this.running = false;
        this.interrupt();
        ArrayList<Future> cancelFutures = new ArrayList<Future>();
        for (Map.Entry<Long, Future> entry : this.pendingFuture.entrySet()) {
            if (entry.getValue().isDone()) continue;
            this.logger.warn("WARN ## Task future processId[{}] canceled!", (Object)entry.getKey());
            cancelFutures.add(entry.getValue());
        }
        for (Future future : cancelFutures) {
            future.cancel(true);
        }
        this.pendingFuture.clear();
    }

    protected void sendRollbackTermin(long pipelineId, Throwable exception) {
        this.sendRollbackTermin(pipelineId, ExceptionUtils.getFullStackTrace((Throwable)exception));
    }

    protected void sendRollbackTermin(long pipelineId, String message) {
        TerminEventData errorEventData = new TerminEventData();
        errorEventData.setPipelineId(Long.valueOf(pipelineId));
        errorEventData.setType(TerminEventData.TerminType.ROLLBACK);
        errorEventData.setCode("setl");
        errorEventData.setDesc(message);
        this.arbitrateEventService.terminEvent().single(errorEventData);
        try {
            Thread.sleep(3000 + RandomUtils.nextInt((int)3000));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void processMissData(long pipelineId, String message) {
        TerminEventData errorEventData = new TerminEventData();
        errorEventData.setPipelineId(Long.valueOf(pipelineId));
        errorEventData.setType(TerminEventData.TerminType.RESTART);
        errorEventData.setCode("setl");
        errorEventData.setDesc(message);
        this.arbitrateEventService.terminEvent().single(errorEventData);
    }

    protected String createTaskName(long pipelineId, String taskName) {
        return "pipelineId = " + pipelineId + ",taskName = " + taskName;
    }

    protected boolean isProfiling() {
        return this.stageAggregationCollector.isProfiling();
    }

    protected boolean isInterrupt(Throwable e) {
        if (!this.running) {
            return true;
        }
        if (e instanceof InterruptedException || e instanceof ZkInterruptedException) {
            return true;
        }
        return ExceptionUtils.getRootCause((Throwable)e) instanceof InterruptedException;
    }

    public Collection<Long> getPendingProcess() {
        ArrayList<Long> result = new ArrayList<Long>(this.pendingFuture.keySet());
        Collections.sort(result);
        return result;
    }

    public void setArbitrateEventService(ArbitrateEventService arbitrateEventService) {
        this.arbitrateEventService = arbitrateEventService;
    }

    public void setRowDataPipeDelegate(RowDataPipeDelegate rowDataPipeDelegate) {
        this.rowDataPipeDelegate = rowDataPipeDelegate;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setStageAggregationCollector(StageAggregationCollector stageAggregationCollector) {
        this.stageAggregationCollector = stageAggregationCollector;
    }
}

