/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http.archive;

import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.ArchiveException;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.ArchiveRetriverCallback;
import com.alibaba.otter.node.etl.common.pipe.impl.http.archive.LazyFileInputStream;
import com.alibaba.otter.shared.common.utils.NioUtils;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import com.alibaba.otter.shared.etl.model.FileData;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import de.schlichtherle.util.zip.ZipOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ArchiveBean
implements InitializingBean,
DisposableBean {
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final String WORKER_NAME = "AttachmentHttpPipe";
    private int poolSize = 5;
    private ExecutorService executor;
    private int retry = 3;
    private boolean useLocalFileMutliThread = true;

    public boolean pack(File targetArchiveFile, List<FileData> fileDatas, ArchiveRetriverCallback<FileData> callback) throws ArchiveException {
        int count = 0;
        Exception exception = null;
        while (++count <= this.retry) {
            try {
                return this.doPack(targetArchiveFile, fileDatas, callback);
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        throw new ArchiveException("pack fileDatas error!", exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean doPack(File targetArchiveFile, List<FileData> fileDatas, final ArchiveRetriverCallback<FileData> callback) {
        boolean exist;
        block20: {
            File targetDir;
            ZipOutputStream zipOut;
            block19: {
                if (targetArchiveFile.exists() && !NioUtils.delete((File)targetArchiveFile, (int)3)) {
                    throw new ArchiveException(String.format("[%s] exist and delete failed", targetArchiveFile.getAbsolutePath()));
                }
                exist = false;
                zipOut = null;
                HashSet<String> entryNames = new HashSet<String>();
                LinkedBlockingQueue queue = new LinkedBlockingQueue();
                ExecutorCompletionService<ArchiveEntry> completionService = new ExecutorCompletionService<ArchiveEntry>(this.executor, queue);
                targetDir = new File(targetArchiveFile.getParentFile(), FilenameUtils.getBaseName((String)targetArchiveFile.getPath()));
                FileUtils.forceMkdir((File)targetDir);
                zipOut = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(targetArchiveFile)));
                zipOut.setLevel(1);
                for (final FileData fileData : fileDatas) {
                    if (fileData.getEventType().isDelete()) continue;
                    String namespace = fileData.getNameSpace();
                    String path = fileData.getPath();
                    boolean isLocal = StringUtils.isBlank((String)namespace);
                    String entryName = null;
                    entryName = true == isLocal ? FilenameUtils.getPath((String)path) + FilenameUtils.getName((String)path) : namespace + File.separator + path;
                    if (entryNames.contains(entryName)) continue;
                    entryNames.add(entryName);
                    final String name = entryName;
                    if (isLocal && !this.useLocalFileMutliThread) {
                        queue.add(new DummyFuture(new ArchiveEntry(name, callback.retrive(fileData))));
                        continue;
                    }
                    completionService.submit(new Callable<ArchiveEntry>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public ArchiveEntry call() throws Exception {
                            FileOutputStream output;
                            InputStream input;
                            block4: {
                                ArchiveEntry archiveEntry;
                                input = null;
                                output = null;
                                try {
                                    input = callback.retrive(fileData);
                                    if (input instanceof LazyFileInputStream) {
                                        input = ((LazyFileInputStream)input).getInputSteam();
                                    }
                                    if (input == null) break block4;
                                    File tmp = new File(targetDir, name);
                                    NioUtils.create((File)tmp.getParentFile(), (boolean)false, (int)3);
                                    output = new FileOutputStream(tmp);
                                    NioUtils.copy((InputStream)input, (OutputStream)output);
                                    archiveEntry = new ArchiveEntry(name, new File(targetDir, name));
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(input);
                                    IOUtils.closeQuietly(output);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((InputStream)input);
                                IOUtils.closeQuietly((OutputStream)output);
                                return archiveEntry;
                            }
                            ArchiveEntry archiveEntry = new ArchiveEntry(name);
                            IOUtils.closeQuietly((InputStream)input);
                            IOUtils.closeQuietly(output);
                            return archiveEntry;
                        }
                    });
                }
                for (int i = 0; i < entryNames.size(); ++i) {
                    InputStream stream;
                    ArchiveEntry input;
                    block18: {
                        block17: {
                            input = null;
                            stream = null;
                            try {
                                input = (ArchiveEntry)((Future)queue.take()).get();
                                if (input != null) break block17;
                            }
                            catch (Throwable throwable) {
                                IOUtils.closeQuietly(stream);
                                throw throwable;
                            }
                            IOUtils.closeQuietly(stream);
                            continue;
                        }
                        stream = input.getStream();
                        if (stream != null) break block18;
                        IOUtils.closeQuietly((InputStream)stream);
                        continue;
                    }
                    if (stream instanceof LazyFileInputStream) {
                        stream = ((LazyFileInputStream)stream).getInputSteam();
                    }
                    exist = true;
                    zipOut.putNextEntry(new ZipEntry(input.getName()));
                    NioUtils.copy((InputStream)stream, (OutputStream)zipOut);
                    zipOut.closeEntry();
                    IOUtils.closeQuietly((InputStream)stream);
                }
                if (!exist) break block19;
                zipOut.finish();
            }
            IOUtils.closeQuietly((OutputStream)zipOut);
            try {
                FileUtils.deleteDirectory((File)targetDir);
            }
            catch (IOException i) {}
            break block20;
            catch (Exception e) {
                try {
                    throw new ArchiveException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zipOut);
                    try {
                        FileUtils.deleteDirectory((File)targetDir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> unpack(File archiveFile, File targetDir) throws ArchiveException {
        if (!archiveFile.exists()) {
            throw new ArchiveException(String.format("[%s] not exist", archiveFile.getAbsolutePath()));
        }
        if (!targetDir.exists() && !NioUtils.create((File)targetDir, (boolean)false, (int)3)) {
            throw new ArchiveException(String.format("[%s] not exist and create failed", targetDir.getAbsolutePath()));
        }
        ArrayList<File> result = new ArrayList<File>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(archiveFile);
            Enumeration entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                String entryName = entry.getName();
                File targetFile = new File(targetDir, entryName);
                NioUtils.create((File)targetFile.getParentFile(), (boolean)false, (int)3);
                InputStream input = null;
                FileOutputStream output = null;
                try {
                    output = new FileOutputStream(targetFile);
                    input = zipFile.getInputStream(entry);
                    NioUtils.copy((InputStream)input, (OutputStream)output);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    IOUtils.closeQuietly((OutputStream)output);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly((OutputStream)output);
                result.add(targetFile);
            }
        }
        catch (Exception e) {
            throw new ArchiveException(e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public void adjustPoolSize(int newPoolSize) {
        if (newPoolSize != this.poolSize) {
            this.poolSize = newPoolSize;
            if (this.executor instanceof ThreadPoolExecutor) {
                ThreadPoolExecutor pool = (ThreadPoolExecutor)this.executor;
                pool.setCorePoolSize(newPoolSize);
                pool.setMaximumPoolSize(newPoolSize);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.poolSize * 4), (ThreadFactory)new NamedThreadFactory(WORKER_NAME), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void destroy() throws Exception {
        this.executor.shutdownNow();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setUseLocalFileMutliThread(boolean useLocalFileMutliThread) {
        this.useLocalFileMutliThread = useLocalFileMutliThread;
    }

    private static class DummyFuture
    implements Future<ArchiveEntry> {
        private ArchiveEntry entry;

        public DummyFuture(ArchiveEntry entry) {
            this.entry = entry;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public ArchiveEntry get() throws InterruptedException, ExecutionException {
            return this.entry;
        }

        @Override
        public ArchiveEntry get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.entry;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }
    }

    public static class ArchiveEntry {
        private String name;
        private File localFile = null;
        private InputStream stream = null;

        public ArchiveEntry(String name) {
            this.name = name;
        }

        public ArchiveEntry(String name, InputStream stream) {
            this.name = name;
            this.stream = stream;
        }

        public ArchiveEntry(String name, File localFile) {
            this.name = name;
            this.localFile = localFile;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InputStream getStream() {
            if (this.localFile != null) {
                try {
                    return new FileInputStream(this.localFile);
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveException(e);
                }
            }
            return this.stream;
        }

        public void setStream(InputStream stream) {
            this.stream = stream;
        }
    }
}

