/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http;

import com.alibaba.otter.node.etl.common.io.EncryptedData;
import com.alibaba.otter.node.etl.common.io.download.DataRetriever;
import com.alibaba.otter.node.etl.common.pipe.PipeDataType;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.http.AbstractHttpPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.http.HttpPipeKey;
import com.alibaba.otter.node.etl.common.pipe.impl.http.LimitedInputStream;
import com.alibaba.otter.node.etl.model.protobuf.BatchProto;
import com.alibaba.otter.shared.common.model.config.channel.ChannelParameter;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.ByteUtils;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventColumn;
import com.alibaba.otter.shared.etl.model.EventData;
import com.alibaba.otter.shared.etl.model.EventType;
import com.alibaba.otter.shared.etl.model.FileBatch;
import com.alibaba.otter.shared.etl.model.FileData;
import com.alibaba.otter.shared.etl.model.Identity;
import com.alibaba.otter.shared.etl.model.RowBatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class RowDataHttpPipe
extends AbstractHttpPipe<DbBatch, HttpPipeKey> {
    @Override
    public HttpPipeKey put(DbBatch data) throws PipeException {
        return this.saveDbBatch(data);
    }

    @Override
    public DbBatch get(HttpPipeKey key) throws PipeException {
        return this.getDbBatch(key);
    }

    private HttpPipeKey saveDbBatch(DbBatch dbBatch) {
        RowBatch rowBatch = dbBatch.getRowBatch();
        BatchProto.RowBatch.Builder rowBatchBuilder = BatchProto.RowBatch.newBuilder();
        rowBatchBuilder.setIdentity(this.build(rowBatch.getIdentity()));
        for (EventData eventData : rowBatch.getDatas()) {
            BatchProto.RowData.Builder rowDataBuilder = BatchProto.RowData.newBuilder();
            rowDataBuilder.setPairId(eventData.getPairId());
            rowDataBuilder.setTableId(eventData.getTableId());
            if (eventData.getSchemaName() != null) {
                rowDataBuilder.setSchemaName(eventData.getSchemaName());
            }
            rowDataBuilder.setTableName(eventData.getTableName());
            rowDataBuilder.setEventType(eventData.getEventType().getValue());
            rowDataBuilder.setExecuteTime(eventData.getExecuteTime());
            if (eventData.getSyncMode() != null) {
                rowDataBuilder.setSyncMode(eventData.getSyncMode().getValue());
            }
            if (eventData.getSyncConsistency() != null) {
                rowDataBuilder.setSyncConsistency(eventData.getSyncConsistency().getValue());
            }
            for (EventColumn keyColumn : eventData.getKeys()) {
                rowDataBuilder.addKeys(this.buildColumn(keyColumn));
            }
            if (!CollectionUtils.isEmpty((Collection)eventData.getOldKeys())) {
                for (EventColumn keyColumn : eventData.getOldKeys()) {
                    rowDataBuilder.addOldKeys(this.buildColumn(keyColumn));
                }
            }
            for (EventColumn column : eventData.getColumns()) {
                rowDataBuilder.addColumns(this.buildColumn(column));
            }
            rowDataBuilder.setRemedy(eventData.isRemedy());
            rowDataBuilder.setSize(eventData.getSize());
            if (StringUtils.isNotEmpty((String)eventData.getSql())) {
                rowDataBuilder.setSql(eventData.getSql());
            }
            if (StringUtils.isNotEmpty((String)eventData.getDdlSchemaName())) {
                rowDataBuilder.setDdlSchemaName(eventData.getDdlSchemaName());
            }
            if (StringUtils.isNotEmpty((String)eventData.getHint())) {
                rowDataBuilder.setHint(eventData.getHint());
            }
            rowDataBuilder.setWithoutSchema(eventData.isWithoutSchema());
            rowBatchBuilder.addRows(rowDataBuilder.build());
        }
        FileBatch fileBatch = dbBatch.getFileBatch();
        BatchProto.FileBatch.Builder fileBatchBuilder = null;
        fileBatchBuilder = BatchProto.FileBatch.newBuilder();
        fileBatchBuilder.setIdentity(this.build(fileBatch.getIdentity()));
        for (FileData fileData : fileBatch.getFiles()) {
            BatchProto.FileData.Builder fileDataBuilder = BatchProto.FileData.newBuilder();
            fileDataBuilder.setPairId(fileData.getPairId());
            fileDataBuilder.setTableId(fileData.getTableId());
            if (fileData.getNameSpace() != null) {
                fileDataBuilder.setNamespace(fileData.getNameSpace());
            }
            if (fileData.getPath() != null) {
                fileDataBuilder.setPath(fileData.getPath());
            }
            fileDataBuilder.setEventType(fileData.getEventType().getValue());
            fileDataBuilder.setSize(fileData.getSize());
            fileDataBuilder.setLastModifiedTime(fileData.getLastModifiedTime());
            fileBatchBuilder.addFiles(fileDataBuilder.build());
        }
        String filename = this.buildFileName(rowBatch.getIdentity(), ClassUtils.getShortClassName(dbBatch.getClass()));
        File file = new File(this.htdocsDir, filename);
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            BatchProto.RowBatch rowBatchProto = rowBatchBuilder.build();
            ((OutputStream)output).write(ByteUtils.int2bytes((int)rowBatchProto.getSerializedSize()));
            rowBatchProto.writeTo(output);
            BatchProto.FileBatch fileBatchProto = fileBatchBuilder.build();
            ((OutputStream)output).write(ByteUtils.int2bytes((int)fileBatchProto.getSerializedSize()));
            fileBatchProto.writeTo(output);
            ((OutputStream)output).flush();
        }
        catch (IOException e) {
            try {
                throw new PipeException("write_byte_error", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        HttpPipeKey key = new HttpPipeKey();
        key.setUrl(this.remoteUrlBuilder.getUrl(rowBatch.getIdentity().getPipelineId(), filename));
        key.setDataType(PipeDataType.DB_BATCH);
        key.setIdentity(rowBatch.getIdentity());
        Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(rowBatch.getIdentity().getPipelineId()));
        if (pipeline.getParameters().getUseFileEncrypt().booleanValue()) {
            EncryptedData encryptedData = this.encryptFile(file);
            key.setKey(encryptedData.getKey());
            key.setCrc(encryptedData.getCrc());
        }
        return key;
    }

    private DbBatch getDbBatch(HttpPipeKey key) {
        String dataUrl = key.getUrl();
        Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(key.getIdentity().getPipelineId()));
        DataRetriever dataRetriever = this.dataRetrieverFactory.createRetriever(pipeline.getParameters().getRetriever(), dataUrl, this.downloadDir);
        File archiveFile = null;
        try {
            dataRetriever.connect();
            dataRetriever.doRetrieve();
            archiveFile = dataRetriever.getDataAsFile();
        }
        catch (Exception e) {
            dataRetriever.abort();
            throw new PipeException("download_error", e);
        }
        finally {
            dataRetriever.disconnect();
        }
        if (StringUtils.isNotEmpty((String)key.getKey()) && StringUtils.isNotEmpty((String)key.getCrc())) {
            this.decodeFile(archiveFile, key.getKey(), key.getCrc());
        }
        BufferedInputStream input = null;
        Closeable reader = null;
        try {
            input = new BufferedInputStream(new FileInputStream(archiveFile));
            DbBatch dbBatch = new DbBatch();
            byte[] lengthBytes = new byte[4];
            ((InputStream)input).read(lengthBytes);
            int length = ByteUtils.bytes2int((byte[])lengthBytes);
            BatchProto.RowBatch rowbatchProto = BatchProto.RowBatch.parseFrom(new LimitedInputStream(input, length));
            RowBatch rowBatch = new RowBatch();
            rowBatch.setIdentity(this.build(rowbatchProto.getIdentity()));
            for (BatchProto.RowData rowDataProto : rowbatchProto.getRowsList()) {
                EventData eventData = new EventData();
                eventData.setPairId(rowDataProto.getPairId());
                eventData.setTableId(rowDataProto.getTableId());
                eventData.setTableName(rowDataProto.getTableName());
                eventData.setSchemaName(rowDataProto.getSchemaName());
                eventData.setEventType(EventType.valuesOf((String)rowDataProto.getEventType()));
                eventData.setExecuteTime(rowDataProto.getExecuteTime());
                if (StringUtils.isNotEmpty((String)rowDataProto.getSyncMode())) {
                    eventData.setSyncMode(ChannelParameter.SyncMode.valuesOf((String)rowDataProto.getSyncMode()));
                }
                if (StringUtils.isNotEmpty((String)rowDataProto.getSyncConsistency())) {
                    eventData.setSyncConsistency(ChannelParameter.SyncConsistency.valuesOf((String)rowDataProto.getSyncConsistency()));
                }
                ArrayList<EventColumn> keys = new ArrayList<EventColumn>();
                for (BatchProto.Column columnProto : rowDataProto.getKeysList()) {
                    keys.add(this.buildColumn(columnProto));
                }
                eventData.setKeys(keys);
                if (!CollectionUtils.isEmpty(rowDataProto.getOldKeysList())) {
                    ArrayList<EventColumn> oldKeys = new ArrayList<EventColumn>();
                    for (BatchProto.Column columnProto : rowDataProto.getOldKeysList()) {
                        oldKeys.add(this.buildColumn(columnProto));
                    }
                    eventData.setOldKeys(oldKeys);
                }
                ArrayList<EventColumn> columns = new ArrayList<EventColumn>();
                for (BatchProto.Column columnProto : rowDataProto.getColumnsList()) {
                    columns.add(this.buildColumn(columnProto));
                }
                eventData.setColumns(columns);
                eventData.setRemedy(rowDataProto.getRemedy());
                eventData.setSize(rowDataProto.getSize());
                eventData.setSql(rowDataProto.getSql());
                eventData.setDdlSchemaName(rowDataProto.getDdlSchemaName());
                eventData.setHint(rowDataProto.getHint());
                eventData.setWithoutSchema(rowDataProto.getWithoutSchema());
                rowBatch.merge(eventData);
            }
            dbBatch.setRowBatch(rowBatch);
            ((InputStream)input).read(lengthBytes);
            length = ByteUtils.bytes2int((byte[])lengthBytes);
            BatchProto.FileBatch filebatchProto = BatchProto.FileBatch.parseFrom(new LimitedInputStream(input, length));
            FileBatch fileBatch = new FileBatch();
            fileBatch.setIdentity(this.build(filebatchProto.getIdentity()));
            for (BatchProto.FileData fileDataProto : filebatchProto.getFilesList()) {
                FileData fileData = new FileData();
                fileData.setPairId(fileDataProto.getPairId());
                fileData.setTableId(fileDataProto.getTableId());
                fileData.setEventType(EventType.valuesOf((String)fileDataProto.getEventType()));
                fileData.setLastModifiedTime(fileDataProto.getLastModifiedTime());
                fileData.setNameSpace(fileDataProto.getNamespace());
                fileData.setPath(fileDataProto.getPath());
                fileData.setSize(fileDataProto.getSize());
                fileBatch.getFiles().add(fileData);
            }
            dbBatch.setFileBatch(fileBatch);
            DbBatch dbBatch2 = dbBatch;
            return dbBatch2;
        }
        catch (IOException e) {
            throw new PipeException("deserial_error", e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    private EventColumn buildColumn(BatchProto.Column columnProto) {
        EventColumn column = new EventColumn();
        column.setColumnName(columnProto.getName());
        column.setNull(columnProto.getIsNull());
        column.setColumnType(columnProto.getType());
        column.setColumnValue(columnProto.getValue());
        column.setKey(columnProto.getIsPrimaryKey());
        column.setIndex(columnProto.getIndex());
        column.setUpdate(columnProto.getIsUpdate());
        return column;
    }

    private BatchProto.Column buildColumn(EventColumn keyColumn) {
        BatchProto.Column.Builder columnBuilder = BatchProto.Column.newBuilder();
        columnBuilder.setName(keyColumn.getColumnName());
        columnBuilder.setType(keyColumn.getColumnType());
        columnBuilder.setIsNull(keyColumn.isNull());
        columnBuilder.setIsPrimaryKey(keyColumn.isKey());
        columnBuilder.setIndex(keyColumn.getIndex());
        if (keyColumn.getColumnValue() != null) {
            columnBuilder.setValue(keyColumn.getColumnValue());
        }
        columnBuilder.setIsUpdate(keyColumn.isUpdate());
        return columnBuilder.build();
    }

    private String buildFileName(Identity identity, String prefix) {
        Date now = new Date();
        String time = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(now);
        return MessageFormat.format("{0}-{1}-{2}-{3}-{4}.gzip", prefix, time, String.valueOf(identity.getChannelId()), String.valueOf(identity.getPipelineId()), String.valueOf(identity.getProcessId()));
    }

    private BatchProto.Identity build(Identity identity) {
        BatchProto.Identity.Builder identityBuilder = BatchProto.Identity.newBuilder();
        identityBuilder.setChannelId(identity.getChannelId());
        identityBuilder.setPipelineId(identity.getPipelineId());
        identityBuilder.setProcessId(identity.getProcessId());
        return identityBuilder.build();
    }

    private Identity build(BatchProto.Identity identityProto) {
        Identity identity = new Identity();
        identity.setChannelId(identityProto.getChannelId());
        identity.setPipelineId(identityProto.getPipelineId());
        identity.setProcessId(identityProto.getProcessId());
        return identity;
    }
}

