/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl.http;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private int limit;

    public LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.limit);
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result = super.read();
        if (result >= 0) {
            --this.limit;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result = super.read(b, off, len = Math.min(len, this.limit));
        if (result >= 0) {
            this.limit -= result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = super.skip(Math.min(n, (long)this.limit));
        if (result >= 0L) {
            this.limit = (int)((long)this.limit - result);
        }
        return result;
    }
}

