/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.pipe.impl;

import com.alibaba.otter.node.common.config.ConfigClientService;
import com.alibaba.otter.node.etl.common.pipe.PipeKey;
import com.alibaba.otter.node.etl.common.pipe.exception.PipeException;
import com.alibaba.otter.node.etl.common.pipe.impl.http.AttachmentHttpPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.http.HttpPipeKey;
import com.alibaba.otter.node.etl.common.pipe.impl.http.RowDataHttpPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.memory.MemoryPipeKey;
import com.alibaba.otter.node.etl.common.pipe.impl.memory.RowDataMemoryPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.rpc.RowDataRpcPipe;
import com.alibaba.otter.node.etl.common.pipe.impl.rpc.RpcPipeKey;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.model.config.pipeline.PipelineParameter;
import com.alibaba.otter.shared.etl.model.DbBatch;
import com.alibaba.otter.shared.etl.model.EventData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.MDC;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RowDataPipeDelegate {
    private RowDataMemoryPipe rowDataMemoryPipe;
    private AttachmentHttpPipe attachmentHttpPipe;
    private RowDataHttpPipe rowDataHttpPipe;
    private RowDataRpcPipe rowDataRpcPipe;
    private ConfigClientService configClientService;
    private ExecutorService executorService;
    private long sizeThresold = 131072L;

    public List<PipeKey> put(final DbBatch data, Long nid) throws PipeException {
        ArrayList<PipeKey> keys = new ArrayList<PipeKey>();
        if (this.isLocal(nid)) {
            keys.add(this.rowDataMemoryPipe.put(data));
        } else {
            Future<PipeKey> future = null;
            Pipeline pipeline = this.configClientService.findPipeline(Long.valueOf(data.getRowBatch().getIdentity().getPipelineId()));
            if (data.getFileBatch() != null && !CollectionUtils.isEmpty((Collection)data.getFileBatch().getFiles())) {
                future = this.executorService.submit(new Callable<PipeKey>(){

                    @Override
                    public PipeKey call() throws Exception {
                        try {
                            MDC.put((String)"otter", (String)String.valueOf(data.getFileBatch().getIdentity().getPipelineId()));
                            HttpPipeKey httpPipeKey = RowDataPipeDelegate.this.attachmentHttpPipe.put(data.getFileBatch());
                            return httpPipeKey;
                        }
                        finally {
                            MDC.remove((String)"otter");
                        }
                    }
                });
            }
            try {
                PipelineParameter.PipeChooseMode pipeChooseMode = pipeline.getParameters().getPipeChooseType();
                if (pipeChooseMode.isAutomatic()) {
                    if (this.calculateSize(data) <= this.sizeThresold) {
                        keys.add(this.rowDataRpcPipe.put(data));
                    } else {
                        keys.add(this.rowDataHttpPipe.put(data));
                    }
                } else if (pipeChooseMode.isRpc()) {
                    keys.add(this.rowDataRpcPipe.put(data));
                } else if (pipeChooseMode.isHttp()) {
                    keys.add(this.rowDataHttpPipe.put(data));
                } else {
                    throw new PipeException("pipeChooseMode is error!" + pipeChooseMode);
                }
                if (future != null) {
                    keys.add(future.get());
                }
            }
            catch (Exception e) {
                throw new PipeException(e);
            }
        }
        return keys;
    }

    public DbBatch get(List<PipeKey> keys) {
        Assert.notNull(keys);
        DbBatch dbBatch = new DbBatch();
        Future<File> future = null;
        for (final PipeKey key : keys) {
            if (key == null) continue;
            if (key instanceof MemoryPipeKey) {
                dbBatch = this.rowDataMemoryPipe.get((MemoryPipeKey)key);
                return dbBatch;
            }
            if (key instanceof HttpPipeKey) {
                if (key.getDataType().isDbBatch()) {
                    dbBatch = this.rowDataHttpPipe.get((HttpPipeKey)key);
                    continue;
                }
                future = this.executorService.submit(new Callable<File>(){

                    @Override
                    public File call() throws Exception {
                        try {
                            HttpPipeKey pipeKey = (HttpPipeKey)key;
                            MDC.put((String)"otter", (String)String.valueOf(pipeKey.getIdentity().getPipelineId()));
                            File file = RowDataPipeDelegate.this.attachmentHttpPipe.get(pipeKey);
                            return file;
                        }
                        finally {
                            MDC.remove((String)"otter");
                        }
                    }
                });
                continue;
            }
            if (key instanceof RpcPipeKey) {
                dbBatch = this.rowDataRpcPipe.get((RpcPipeKey)key);
                continue;
            }
            throw new PipeException("unknow_PipeKey", key.toString());
        }
        if (future != null && dbBatch != null) {
            try {
                dbBatch.setRoot((File)future.get());
            }
            catch (Exception e) {
                throw new PipeException(e);
            }
        }
        return dbBatch;
    }

    private long calculateSize(DbBatch data) {
        long size = 0L;
        for (EventData eventData : data.getRowBatch().getDatas()) {
            size += eventData.getSize();
        }
        return size;
    }

    private boolean isLocal(Long nid) {
        return this.configClientService.currentNode().getId().equals(nid);
    }

    public void setRowDataMemoryPipe(RowDataMemoryPipe rowDataMemoryPipe) {
        this.rowDataMemoryPipe = rowDataMemoryPipe;
    }

    public void setAttachmentHttpPipe(AttachmentHttpPipe attachmentHttpPipe) {
        this.attachmentHttpPipe = attachmentHttpPipe;
    }

    public void setRowDataRpcPipe(RowDataRpcPipe rowDataRpcPipe) {
        this.rowDataRpcPipe = rowDataRpcPipe;
    }

    public void setConfigClientService(ConfigClientService configClientService) {
        this.configClientService = configClientService;
    }

    public void setRowDataHttpPipe(RowDataHttpPipe rowDataHttpPipe) {
        this.rowDataHttpPipe = rowDataHttpPipe;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setSizeThresold(long sizeThresold) {
        this.sizeThresold = sizeThresold;
    }
}

