/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.jmx;

import com.alibaba.otter.node.etl.common.jmx.StageAggregation;
import com.alibaba.otter.shared.common.model.config.enums.StageType;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class StageAggregationCollector {
    private Map<Long, Map<StageType, StageAggregation>> collector;
    private AtomicBoolean profiling = new AtomicBoolean(true);

    public StageAggregationCollector() {
        this(1024);
    }

    public StageAggregationCollector(final int bufferSize) {
        this.collector = OtterMigrateMap.makeComputingMap((Function)new Function<Long, Map<StageType, StageAggregation>>(){

            public Map<StageType, StageAggregation> apply(Long input) {
                return OtterMigrateMap.makeComputingMap((Function)new Function<StageType, StageAggregation>(){

                    public StageAggregation apply(StageType input) {
                        return new StageAggregation(bufferSize);
                    }
                });
            }
        });
    }

    public void push(Long pipelineId, StageType stage, StageAggregation.AggregationItem aggregationItem) {
        this.collector.get(pipelineId).get(stage).push(aggregationItem);
    }

    public String histogram(Long pipelineId, StageType stage) {
        return this.collector.get(pipelineId).get(stage).histogram();
    }

    public boolean isProfiling() {
        return this.profiling.get();
    }

    public void setProfiling(boolean profiling) {
        this.profiling.set(profiling);
    }
}

