/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.download.impl;

import com.alibaba.otter.node.etl.common.io.download.DataRetriever;
import com.alibaba.otter.node.etl.common.io.download.exception.DataRetrieveException;
import com.alibaba.otter.shared.common.utils.NioUtils;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRetriever
implements DataRetriever {
    private static Logger logger = LoggerFactory.getLogger(FileRetriever.class);
    private boolean mAbort = false;
    private long mByteOffset;
    private File mFile;

    public FileRetriever(File pFile) {
        this.mFile = pFile;
    }

    @Override
    public void abort() {
        this.mAbort = true;
    }

    @Override
    public void connect() {
        if (this.mAbort) {
            throw new IllegalStateException("Retriever aborted");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Open file for retrieval: " + this.mFile);
        }
    }

    @Override
    public void doRetrieve() {
    }

    @Override
    public void disconnect() {
        if (logger.isDebugEnabled()) {
            logger.debug("Close file " + this.mFile.getAbsolutePath());
        }
    }

    @Override
    public boolean isDataAvailable() {
        return this.mFile.exists();
    }

    @Override
    public byte[] getDataAsByteArray() {
        try {
            return NioUtils.read((File)this.mFile);
        }
        catch (IOException e) {
            throw new DataRetrieveException(e);
        }
    }

    @Override
    public File getDataAsFile() {
        return this.mFile;
    }

    public void setBytesToSkip(long pBytesToSkip) {
        this.mByteOffset = pBytesToSkip;
    }

    public long getBytesSkipped() {
        return this.mByteOffset;
    }

    @Override
    public long getContentLength() {
        return this.mFile.length();
    }

    @Override
    public void addObserver(Observer o) {
    }
}

