/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.download.impl;

import com.alibaba.otter.node.etl.common.io.download.DataRetriever;
import com.alibaba.otter.node.etl.common.io.download.exception.DataRetrieveException;
import com.alibaba.otter.node.etl.common.io.download.impl.AbstractCommandDownload;
import com.alibaba.otter.node.etl.common.io.download.impl.observer.DefaultExceptionObserver;
import com.alibaba.otter.node.etl.common.io.download.impl.observer.DefaultProgressObserver;
import com.alibaba.otter.node.etl.common.io.download.impl.observer.DefaultStatusObserver;
import com.alibaba.otter.shared.common.utils.NioUtils;
import java.io.File;
import java.io.IOException;
import java.util.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommandRetriever
implements DataRetriever {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AbstractCommandDownload download;

    public AbstractCommandRetriever(String cmdPath, String url, String targetDir) {
        this.buildDownload(cmdPath, url, targetDir, null);
    }

    public AbstractCommandRetriever(String cmdPath, String url, String targetDir, String[] params) {
        this.buildDownload(cmdPath, url, targetDir, params);
    }

    protected abstract void buildDownload(String var1, String var2, String var3, String[] var4);

    @Override
    public void connect() throws DataRetrieveException {
        this.download.addObserver(new DefaultStatusObserver(this.logger));
        this.download.addObserver(new DefaultProgressObserver(this.logger));
        this.download.addObserver(new DefaultExceptionObserver(this.logger));
    }

    @Override
    public void doRetrieve() throws DataRetrieveException {
        try {
            this.download.download();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.download.isCompleted()) {
            if (this.download.isPaused()) {
                throw new DataRetrieveException("retry 3 times still have err, paused.");
            }
            if (this.download.isAborted()) {
                throw new DataRetrieveException("aborted for some configration error.");
            }
        }
    }

    @Override
    public void disconnect() {
        this.download = null;
    }

    @Override
    public void abort() {
        this.download = null;
    }

    @Override
    public void addObserver(Observer o) {
        this.download.addObserver(o);
    }

    @Override
    public long getContentLength() throws IOException {
        if (this.download.isCompleted()) {
            return this.download.getAssociatedLocalFile().length();
        }
        return -1L;
    }

    @Override
    public byte[] getDataAsByteArray() {
        try {
            return NioUtils.read((File)this.getDataAsFile());
        }
        catch (IOException e) {
            throw new DataRetrieveException(e);
        }
    }

    @Override
    public File getDataAsFile() {
        return this.download.getAssociatedLocalFile();
    }

    @Override
    public boolean isDataAvailable() {
        return this.download.isCompleted();
    }
}

