/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.crypto;

import com.alibaba.otter.node.etl.common.io.crypto.AESException;
import com.alibaba.otter.shared.common.utils.ByteUtils;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static final String ENCRYPTION_ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;
    private byte[] secretKey;

    public byte[] generateSecretKey() throws AESException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ENCRYPTION_ALGORITHM);
            kgen.init(128);
            SecretKey skey = kgen.generateKey();
            this.secretKey = skey.getEncoded();
            return this.secretKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AESException(e);
        }
    }

    public byte[] encrypt(byte[] plainData) throws AESException {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(this.secretKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(1, skeySpec);
            return cipher.doFinal(plainData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AESException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new AESException(e);
        }
        catch (InvalidKeyException e) {
            throw new AESException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new AESException(e);
        }
        catch (BadPaddingException e) {
            throw new AESException(e);
        }
    }

    public byte[] decrypt(byte[] encrypted) throws AESException {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(this.secretKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(2, skeySpec);
            return cipher.doFinal(encrypted);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AESException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new AESException(e);
        }
        catch (InvalidKeyException e) {
            throw new AESException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new AESException(e);
        }
        catch (BadPaddingException e) {
            throw new AESException(e);
        }
    }

    public String getSecretyKeyString() {
        return ByteUtils.bytesToBase64String((byte[])this.secretKey);
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(byte[] secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecretKeyString(String keyString) {
        this.secretKey = ByteUtils.base64StringToBytes((String)keyString);
    }
}

