/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.compress.impl.bzip2;

import com.alibaba.otter.node.etl.common.io.compress.exception.CompressException;
import com.alibaba.otter.node.etl.common.io.compress.impl.AbstractCompressor;
import com.alibaba.otter.shared.common.utils.NioUtils;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public class BZip2Compressor
extends AbstractCompressor {
    private static String DEFAULT_FILE_EXTENSION = "bz2";
    private static final byte[] HEADER = new byte[]{66, 90, 104};
    private static final String NAME = "bz2";

    @Override
    public void compressTo(InputStream in, OutputStream out) throws CompressException {
        BZip2CompressorOutputStream outputBZStream = null;
        try {
            outputBZStream = new BZip2CompressorOutputStream(out);
            NioUtils.copy((InputStream)in, (OutputStream)outputBZStream);
            outputBZStream.finish();
        }
        catch (Exception e) {
            throw new CompressException("bzip_compress_error", e);
        }
    }

    @Override
    public void decompressTo(InputStream in, OutputStream out) throws CompressException {
        BZip2CompressorInputStream inputStream = null;
        try {
            inputStream = new BZip2CompressorInputStream(in);
            NioUtils.copy((InputStream)inputStream, (OutputStream)out);
        }
        catch (Exception e) {
            throw new CompressException("bzip_decompress_error", e);
        }
    }

    @Override
    public byte[] getHeader() {
        return HEADER;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDefaultFileExtension() {
        return DEFAULT_FILE_EXTENSION;
    }
}

