/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.compress.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackableObject {
    protected static final int CHOOSE_EXTENSION = 1;
    protected static final int CHOOSE_NAME = 2;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public abstract byte[] getHeader();

    public abstract String getDefaultFileExtension();

    public abstract String getName();

    protected boolean isPackableWith(Object value, int choose) {
        if (value == null) {
            return false;
        }
        return choose == 1 ? value.equals(this.getDefaultFileExtension()) : choose == 2 && value.equals(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackableObject identifyByHeader(File file, List packables) throws IOException {
        PackableObject packableObject;
        FileInputStream fis;
        block8: {
            PackableObject packableObject2;
            fis = null;
            try {
                Iterator it;
                String extension;
                block9: {
                    PackableObject p2;
                    block7: {
                        fis = new FileInputStream(file);
                        byte[] headerBytes = new byte[20];
                        fis.read(headerBytes, 0, 20);
                        for (PackableObject p2 : packables) {
                            byte[] fieldHeader = p2.getHeader();
                            if (fieldHeader == null || !PackableObject.compareByteArrays(headerBytes, fieldHeader)) continue;
                            break block7;
                        }
                        String name = file.getName();
                        extension = null;
                        String[] s = name.split("\\.");
                        if (s.length > 1) {
                            extension = s[s.length - 1];
                        }
                        it = packables.iterator();
                        break block9;
                    }
                    PackableObject packableObject3 = p2;
                    IOUtils.closeQuietly((InputStream)fis);
                    return packableObject3;
                }
                while (it.hasNext()) {
                    PackableObject p = (PackableObject)it.next();
                    if (!p.isPackableWith(extension, 1)) continue;
                    packableObject = p;
                    break block8;
                }
                packableObject2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return packableObject2;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return packableObject;
    }

    private static boolean compareByteArrays(byte[] source, byte[] match) {
        for (int i = 0; source.length < i || i < match.length; ++i) {
            if (source[i] == match[i]) continue;
            return false;
        }
        return true;
    }
}

