/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io.compress.impl;

import com.alibaba.otter.node.etl.common.io.compress.Compressor;
import com.alibaba.otter.node.etl.common.io.compress.exception.CompressException;
import com.alibaba.otter.node.etl.common.io.compress.impl.PackableObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public abstract class AbstractCompressor
extends PackableObject
implements Compressor {
    @Override
    public abstract String getDefaultFileExtension();

    @Override
    public InputStream compress(InputStream input) throws CompressException {
        FileInputStream fileInputStream;
        FileOutputStream output = null;
        try {
            File temp = File.createTempFile("compress_", "jkt");
            output = new FileOutputStream(temp);
            this.compressTo(input, output);
            fileInputStream = new FileInputStream(temp);
        }
        catch (IOException e) {
            try {
                throw new CompressException("An I/O Exception has occured", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        return fileInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] data) throws CompressException {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.compressTo(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    @Override
    public void compressToHere(File input) throws CompressException {
        String pathToFile = input.getAbsolutePath();
        File output = new File(pathToFile);
        this.compressTo(input, output);
    }

    @Override
    public void compressTo(File input, File output) throws CompressException {
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            inputStream = new FileInputStream(input);
            this.compressTo(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompressException("File not found", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    @Override
    public InputStream compress(File input) throws CompressException {
        InputStream inputStream;
        FileInputStream inputStream2 = null;
        try {
            inputStream2 = new FileInputStream(input);
            inputStream = this.compress(inputStream2);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompressException("File not found", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream2);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream2);
        return inputStream;
    }

    @Override
    public InputStream decompress(File input) throws CompressException {
        File temp = null;
        FileInputStream result = null;
        try {
            temp = File.createTempFile("compress_", "jkt");
            this.decompressTo(input, temp);
            result = new FileInputStream(temp);
        }
        catch (IOException e) {
            throw new CompressException("Error while creating a temporary file", e);
        }
        return result;
    }

    @Override
    public InputStream decompress(InputStream input) throws CompressException {
        File temp = null;
        FileInputStream result = null;
        FileOutputStream output = null;
        try {
            temp = File.createTempFile("compress_", "jkt");
            output = new FileOutputStream(temp);
            this.decompressTo(input, output);
            result = new FileInputStream(temp);
        }
        catch (IOException e) {
            try {
                throw new CompressException("Error while creating a temporary file", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decompress(byte[] data) throws CompressException {
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            this.decompressTo(input, output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
            IOUtils.closeQuietly((OutputStream)output);
        }
    }

    @Override
    public void decompressTo(File input, File output) throws CompressException {
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(output);
            inputStream = new FileInputStream(input);
            this.decompressTo(inputStream, outputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new CompressException("File could not be found", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }
}

