/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.io;

import com.alibaba.otter.node.etl.common.io.EncryptedData;
import com.alibaba.otter.node.etl.common.io.compress.Compressor;
import com.alibaba.otter.node.etl.common.io.compress.impl.gzip.GzipCompressor;
import com.alibaba.otter.node.etl.common.io.crypto.AESUtils;
import com.alibaba.otter.node.etl.common.io.signature.ChecksumException;
import com.alibaba.otter.node.etl.common.io.signature.ChecksumUtils;
import org.apache.commons.lang.StringUtils;

public class EncryptUtils {
    private static final Compressor COMPRESSOR = new GzipCompressor();

    public static EncryptedData encrypt(byte[] input) {
        byte[] compData = COMPRESSOR.compress(input);
        AESUtils aes = new AESUtils();
        aes.generateSecretKey();
        byte[] encryptData = aes.encrypt(compData);
        return new EncryptedData(encryptData, aes.getSecretyKeyString(), ChecksumUtils.checksum(encryptData));
    }

    public static byte[] decrypt(EncryptedData encode) {
        String destCrc = ChecksumUtils.checksum(encode.getData());
        if (!StringUtils.equals((String)encode.getCrc(), (String)destCrc)) {
            throw new ChecksumException(String.format("orig: %s, parsed: %s not match", encode.getCrc(), destCrc));
        }
        AESUtils aes = new AESUtils();
        aes.setSecretKeyString(encode.getKey());
        return COMPRESSOR.decompress(aes.decrypt(encode.getData()));
    }
}

