/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect.oracle;

import com.alibaba.otter.node.etl.common.db.dialect.AbstractDbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.oracle.OracleSqlTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;

public class OracleDialect
extends AbstractDbDialect {
    public OracleDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler) {
        super(jdbcTemplate, lobHandler);
        this.sqlTemplate = new OracleSqlTemplate();
    }

    public OracleDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler, String name, int majorVersion, int minorVersion) {
        super(jdbcTemplate, lobHandler, name, majorVersion, minorVersion);
        this.sqlTemplate = new OracleSqlTemplate();
    }

    @Override
    public boolean isCharSpacePadded() {
        return true;
    }

    @Override
    public boolean isCharSpaceTrimmed() {
        return false;
    }

    @Override
    public boolean isEmptyStringNulled() {
        return true;
    }

    public boolean storesUpperCaseNamesInCatalog() {
        return true;
    }

    @Override
    public boolean isSupportMergeSql() {
        return true;
    }

    @Override
    public String getDefaultCatalog() {
        return null;
    }

    @Override
    public String getDefaultSchema() {
        return (String)this.jdbcTemplate.queryForObject("SELECT sys_context('USERENV', 'CURRENT_SCHEMA') FROM dual", String.class);
    }
}

