/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect.mysql;

import com.alibaba.otter.node.etl.common.db.dialect.AbstractDbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.mysql.MysqlSqlTemplate;
import com.alibaba.otter.shared.common.utils.meta.DdlUtils;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.util.Assert;

public class MysqlDialect
extends AbstractDbDialect {
    private boolean isDRDS = false;
    private Map<List<String>, String> shardColumns;

    public MysqlDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler) {
        super(jdbcTemplate, lobHandler);
        this.sqlTemplate = new MysqlSqlTemplate();
    }

    public MysqlDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler, String name, String databaseVersion, int majorVersion, int minorVersion) {
        super(jdbcTemplate, lobHandler, name, majorVersion, minorVersion);
        this.sqlTemplate = new MysqlSqlTemplate();
        if (StringUtils.contains((String)databaseVersion, (String)"-TDDL-")) {
            this.isDRDS = true;
            this.initShardColumns();
        }
    }

    private void initShardColumns() {
        this.shardColumns = OtterMigrateMap.makeSoftValueComputingMap((Function)new Function<List<String>, String>(){

            public String apply(List<String> names) {
                Assert.isTrue((names.size() == 2 ? 1 : 0) != 0);
                try {
                    String result = DdlUtils.getShardKeyByDRDS((JdbcTemplate)MysqlDialect.this.jdbcTemplate, (String)names.get(0), (String)names.get(0), (String)names.get(1));
                    if (StringUtils.isEmpty((String)result)) {
                        return "";
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new NestableRuntimeException("find table [" + names.get(0) + "." + names.get(1) + "] error", (Throwable)e);
                }
            }
        });
    }

    @Override
    public boolean isCharSpacePadded() {
        return false;
    }

    @Override
    public boolean isCharSpaceTrimmed() {
        return true;
    }

    @Override
    public boolean isEmptyStringNulled() {
        return false;
    }

    @Override
    public boolean isSupportMergeSql() {
        return true;
    }

    @Override
    public String getDefaultSchema() {
        return null;
    }

    @Override
    public boolean isDRDS() {
        return this.isDRDS;
    }

    @Override
    public String getShardColumns(String schema, String table) {
        if (this.isDRDS()) {
            return this.shardColumns.get(Arrays.asList(schema, table));
        }
        return null;
    }

    @Override
    public String getDefaultCatalog() {
        return (String)this.jdbcTemplate.queryForObject("select database()", String.class);
    }
}

