/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect;

import com.alibaba.otter.node.etl.common.db.dialect.AbstractDbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.DbDialect;
import com.alibaba.otter.node.etl.common.db.dialect.mysql.MysqlDialect;
import com.alibaba.otter.node.etl.common.db.dialect.oracle.OracleDialect;
import com.alibaba.otter.shared.common.model.config.data.DataMediaType;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.lob.LobHandler;

public class DbDialectGenerator {
    protected static final String ORACLE = "oracle";
    protected static final String MYSQL = "mysql";
    protected static final String TDDL_GROUP = "TGroupDatabase";
    protected static final String TDDL_CLIENT = "TDDL";
    protected LobHandler defaultLobHandler;
    protected LobHandler oracleLobHandler;

    protected DbDialect generate(JdbcTemplate jdbcTemplate, String databaseName, String databaseNameVersion, int databaseMajorVersion, int databaseMinorVersion, DataMediaType dataMediaType) {
        AbstractDbDialect dialect = null;
        if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)ORACLE)) {
            dialect = new OracleDialect(jdbcTemplate, this.oracleLobHandler, databaseName, databaseMajorVersion, databaseMinorVersion);
        } else if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)MYSQL)) {
            dialect = new MysqlDialect(jdbcTemplate, this.defaultLobHandler, databaseName, databaseNameVersion, databaseMajorVersion, databaseMinorVersion);
        } else {
            if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)TDDL_GROUP)) {
                throw new RuntimeException(databaseName + " type is not support!");
            }
            if (StringUtils.startsWithIgnoreCase((String)databaseName, (String)TDDL_CLIENT)) {
                throw new RuntimeException(databaseName + " type is not support!");
            }
        }
        return dialect;
    }

    public void setDefaultLobHandler(LobHandler defaultLobHandler) {
        this.defaultLobHandler = defaultLobHandler;
    }

    public void setOracleLobHandler(LobHandler oracleLobHandler) {
        this.oracleLobHandler = oracleLobHandler;
    }
}

