/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.db.dialect;

import com.alibaba.otter.node.etl.common.db.dialect.SqlTemplate;

public abstract class AbstractSqlTemplate
implements SqlTemplate {
    private static final String DOT = ".";

    @Override
    public String getSelectSql(String schemaName, String tableName, String[] pkNames, String[] columnNames) {
        StringBuilder sql = new StringBuilder("select ");
        int size = columnNames.length;
        for (int i = 0; i < size; ++i) {
            sql.append(this.appendEscape(columnNames[i])).append(i + 1 < size ? " , " : "");
        }
        sql.append(" from ").append(this.getFullName(schemaName, tableName)).append(" where ( ");
        this.appendColumnEquals(sql, pkNames, "and");
        sql.append(" ) ");
        return sql.toString().intern();
    }

    @Override
    public String getUpdateSql(String schemaName, String tableName, String[] pkNames, String[] columnNames, boolean updatePks, String shardColumn) {
        StringBuilder sql = new StringBuilder("update " + this.getFullName(schemaName, tableName) + " set ");
        this.appendExcludeSingleShardColumnEquals(sql, columnNames, ",", updatePks, shardColumn);
        sql.append(" where (");
        this.appendColumnEquals(sql, pkNames, "and");
        sql.append(")");
        return sql.toString().intern();
    }

    @Override
    public String getInsertSql(String schemaName, String tableName, String[] pkNames, String[] columnNames) {
        StringBuilder sql = new StringBuilder("insert into " + this.getFullName(schemaName, tableName) + "(");
        String[] allColumns = new String[pkNames.length + columnNames.length];
        System.arraycopy(columnNames, 0, allColumns, 0, columnNames.length);
        System.arraycopy(pkNames, 0, allColumns, columnNames.length, pkNames.length);
        int size = allColumns.length;
        for (int i = 0; i < size; ++i) {
            sql.append(this.appendEscape(allColumns[i])).append(i + 1 < size ? "," : "");
        }
        sql.append(") values (");
        this.appendColumnQuestions(sql, allColumns);
        sql.append(")");
        return sql.toString().intern();
    }

    @Override
    public String getDeleteSql(String schemaName, String tableName, String[] pkNames) {
        StringBuilder sql = new StringBuilder("delete from " + this.getFullName(schemaName, tableName) + " where ");
        this.appendColumnEquals(sql, pkNames, "and");
        return sql.toString().intern();
    }

    protected String getFullName(String schemaName, String tableName) {
        StringBuilder sb = new StringBuilder();
        if (schemaName != null) {
            sb.append(this.appendEscape(schemaName)).append(DOT);
        }
        sb.append(this.appendEscape(tableName));
        return sb.toString().intern();
    }

    protected String appendEscape(String columnName) {
        return columnName;
    }

    protected void appendColumnQuestions(StringBuilder sql, String[] columns) {
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            sql.append("?").append(i + 1 < size ? " , " : "");
        }
    }

    protected void appendColumnEquals(StringBuilder sql, String[] columns, String separator) {
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            sql.append(" ").append(this.appendEscape(columns[i])).append(" = ").append("? ");
            if (i == size - 1) continue;
            sql.append(separator);
        }
    }

    protected void appendExcludeSingleShardColumnEquals(StringBuilder sql, String[] columns, String separator, boolean updatePks, String excludeShardColumn) {
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            if (!updatePks && excludeShardColumn != null && columns[i].equals(excludeShardColumn)) continue;
            sql.append(" ").append(this.appendEscape(columns[i])).append(" = ").append("? ");
            if (i == size - 1) continue;
            sql.append(separator);
        }
    }
}

