/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.node.etl.common.datasource.impl;

import com.alibaba.otter.common.push.datasource.DataSourceHanlder;
import com.alibaba.otter.node.etl.common.datasource.DataSourceService;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.DataMediaType;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DBDataSourceService
implements DataSourceService,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DBDataSourceService.class);
    private List<DataSourceHanlder> dataSourceHandlers;
    private int maxWait = 60000;
    private int minIdle = 0;
    private int initialSize = 0;
    private int maxActive = 32;
    private int maxIdle = 32;
    private int numTestsPerEvictionRun = -1;
    private int timeBetweenEvictionRunsMillis = 60000;
    private int removeAbandonedTimeout = 300;
    private int minEvictableIdleTimeMillis = 300000;
    private Map<Long, Map<DbMediaSource, DataSource>> dataSources = OtterMigrateMap.makeComputingMap((Function)new Function<Long, Map<DbMediaSource, DataSource>>(){

        public Map<DbMediaSource, DataSource> apply(final Long pipelineId) {
            return OtterMigrateMap.makeComputingMap((Function)new Function<DbMediaSource, DataSource>(){

                public DataSource apply(DbMediaSource dbMediaSource) {
                    DataSource customDataSource = DBDataSourceService.this.preCreate(pipelineId, dbMediaSource);
                    if (customDataSource != null) {
                        return customDataSource;
                    }
                    return DBDataSourceService.this.createDataSource(dbMediaSource.getUrl(), dbMediaSource.getUsername(), dbMediaSource.getPassword(), dbMediaSource.getDriver(), dbMediaSource.getType(), dbMediaSource.getEncode());
                }
            });
        }
    });

    public DataSource getDataSource(long pipelineId, DataMediaSource dataMediaSource) {
        Assert.notNull((Object)dataMediaSource);
        return this.dataSources.get(pipelineId).get(dataMediaSource);
    }

    @Override
    public void destroy(Long pipelineId) {
        Map<DbMediaSource, DataSource> sources = this.dataSources.remove(pipelineId);
        if (sources != null) {
            for (DataSource source : sources.values()) {
                try {
                    if (this.letHandlerDestroyIfSupport(pipelineId, source)) continue;
                    BasicDataSource basicDataSource = (BasicDataSource)source;
                    basicDataSource.close();
                }
                catch (SQLException e) {
                    logger.error("ERROR ## close the datasource has an error", (Throwable)e);
                }
            }
            sources.clear();
        }
    }

    private boolean letHandlerDestroyIfSupport(Long pipelineId, DataSource dataSource) {
        boolean destroied = false;
        if (CollectionUtils.isEmpty(this.dataSourceHandlers)) {
            return destroied;
        }
        for (DataSourceHanlder handler : this.dataSourceHandlers) {
            if (!handler.support(dataSource)) continue;
            handler.destory(pipelineId);
            destroied = true;
            return destroied;
        }
        return destroied;
    }

    public void destroy() throws Exception {
        for (Long pipelineId : this.dataSources.keySet()) {
            this.destroy(pipelineId);
        }
    }

    private DataSource createDataSource(String url, String userName, String password, String driverClassName, DataMediaType dataMediaType, String encoding) {
        BasicDataSource dbcpDs = new BasicDataSource();
        dbcpDs.setInitialSize(this.initialSize);
        dbcpDs.setMaxActive(this.maxActive);
        dbcpDs.setMaxIdle(this.maxIdle);
        dbcpDs.setMinIdle(this.minIdle);
        dbcpDs.setMaxWait((long)this.maxWait);
        dbcpDs.setRemoveAbandoned(true);
        dbcpDs.setLogAbandoned(true);
        dbcpDs.setRemoveAbandonedTimeout(this.removeAbandonedTimeout);
        dbcpDs.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        dbcpDs.setTestOnBorrow(false);
        dbcpDs.setTestOnReturn(false);
        dbcpDs.setTestWhileIdle(true);
        dbcpDs.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
        dbcpDs.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
        dbcpDs.setDriverClassName(driverClassName);
        dbcpDs.setUrl(url);
        dbcpDs.setUsername(userName);
        dbcpDs.setPassword(password);
        if (dataMediaType.isOracle()) {
            dbcpDs.addConnectionProperty("restrictGetTables", "true");
            dbcpDs.setValidationQuery("select 1 from dual");
        } else if (dataMediaType.isMysql()) {
            dbcpDs.addConnectionProperty("useServerPrepStmts", "false");
            dbcpDs.addConnectionProperty("rewriteBatchedStatements", "true");
            dbcpDs.addConnectionProperty("zeroDateTimeBehavior", "convertToNull");
            dbcpDs.addConnectionProperty("yearIsDateType", "false");
            dbcpDs.addConnectionProperty("noDatetimeStringSync", "true");
            dbcpDs.addConnectionProperty("jdbcCompliantTruncation", "false");
            if (StringUtils.isNotEmpty((String)encoding)) {
                if (StringUtils.equalsIgnoreCase((String)encoding, (String)"utf8mb4")) {
                    dbcpDs.addConnectionProperty("characterEncoding", "utf8");
                    dbcpDs.setConnectionInitSqls(Arrays.asList("set names utf8mb4"));
                } else {
                    dbcpDs.addConnectionProperty("characterEncoding", encoding);
                }
            }
            dbcpDs.setValidationQuery("select 1");
        } else {
            logger.error("ERROR ## Unknow database type");
        }
        return dbcpDs;
    }

    private DataSource preCreate(Long pipelineId, DbMediaSource dbMediaSource) {
        if (CollectionUtils.isEmpty(this.dataSourceHandlers)) {
            return null;
        }
        DataSource dataSource = null;
        for (DataSourceHanlder handler : this.dataSourceHandlers) {
            if (!handler.support(dbMediaSource) || (dataSource = handler.create(pipelineId, dbMediaSource)) == null) continue;
            return dataSource;
        }
        return null;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setDataSourceHandlers(List<DataSourceHanlder> dataSourceHandlers) {
        this.dataSourceHandlers = dataSourceHandlers;
    }
}

