/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.extend.ha;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.extend.ha.AuthenticationInfoUtils;
import com.alibaba.otter.canal.parse.CanalHASwitchable;
import com.alibaba.otter.canal.parse.exception.CanalHAException;
import com.alibaba.otter.canal.parse.ha.CanalHAController;
import com.alibaba.otter.canal.parse.support.AuthenticationInfo;
import com.alibaba.otter.common.push.supplier.DatasourceChangeCallback;
import com.alibaba.otter.common.push.supplier.DatasourceInfo;
import com.alibaba.otter.common.push.supplier.DatasourceSupplier;
import com.alibaba.otter.common.push.supplier.media.MediaDatasourceSupplier;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaHAController
extends AbstractCanalLifeCycle
implements CanalHAController {
    private static Logger log = LoggerFactory.getLogger(MediaHAController.class);
    private String group;
    private String customUser;
    private String customPasswd;
    private String customSchema;
    private DatasourceSupplier supplier;
    private CanalHASwitchable canalHASwitchable;
    private volatile AuthenticationInfo availableAuthenticationInfo;

    public MediaHAController(String group) {
        this.group = group;
    }

    public MediaHAController(String group, String customUser, String customPasswd, String customSchema) {
        this.group = group;
        this.customUser = customUser;
        this.customPasswd = customPasswd;
        this.customSchema = customSchema;
    }

    public void start() throws CanalHAException {
        super.start();
        if (this.supplier == null) {
            this.validate();
            this.supplier = MediaDatasourceSupplier.newInstance((String)this.group);
        }
        if (!this.supplier.isStart()) {
            this.supplier.start();
        }
        DatasourceInfo fetched = this.supplier.fetchMaster();
        AuthenticationInfo masterFetched = AuthenticationInfoUtils.createFrom(fetched);
        log.info(String.format("medialHAController started for  goup:[%s], and first auth info is : [%s]", this.group, masterFetched));
        this.availableAuthenticationInfo = this.customInfoIfNecessay(masterFetched);
        log.info(String.format("medialHAController customed for goup:[%s], and first auth info is : [%s]", this.group, this.availableAuthenticationInfo));
        this.supplier.addSwtichCallback(new DatasourceChangeCallback(){

            public void masterChanged(DatasourceInfo newMaster) {
                AuthenticationInfo newAuthenticationInfo = AuthenticationInfoUtils.createFrom(newMaster);
                MediaHAController.this.switchEventSource(newAuthenticationInfo);
            }
        });
    }

    private void validate() {
        if (StringUtils.isEmpty((String)this.group)) {
            throw new IllegalStateException(String.format("app or group is empty, app is [%s] , group is [%s]", this.group));
        }
    }

    public void stop() throws CanalHAException {
        super.stop();
        this.supplier.stop();
    }

    private void switchEventSource(AuthenticationInfo newMaster) {
        log.warn(String.format("MediaHAController received a datasource swith from [%s] to [%s]", this.availableAuthenticationInfo, newMaster));
        this.customInfoIfNecessay(newMaster);
        log.warn(String.format("MediaHAController customed a datasource swith from [%s] to [%s]", this.availableAuthenticationInfo, newMaster));
        this.availableAuthenticationInfo = newMaster;
        this.canalHASwitchable.doSwitch(newMaster);
    }

    public void setCanalHASwitchable(CanalHASwitchable canalHASwitchable) {
        this.canalHASwitchable = canalHASwitchable;
    }

    public CanalHASwitchable getCanalHASwitchable() {
        return this.canalHASwitchable;
    }

    public String getGroup() {
        return this.group;
    }

    public DatasourceSupplier getSupplier() {
        return this.supplier;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setSupplier(DatasourceSupplier supplier) {
        this.supplier = supplier;
    }

    public AuthenticationInfo getAvailableAuthenticationInfo() {
        return this.availableAuthenticationInfo;
    }

    public void setAvailableAuthenticationInfo(AuthenticationInfo availableAuthenticationInfo) {
        this.availableAuthenticationInfo = availableAuthenticationInfo;
    }

    protected AuthenticationInfo customInfoIfNecessay(AuthenticationInfo authenticationInfo) {
        if (StringUtils.isNotBlank((String)this.customUser)) {
            authenticationInfo.setUsername(this.customUser);
        }
        if (StringUtils.isNotBlank((String)this.customPasswd)) {
            authenticationInfo.setPassword(this.customPasswd);
        }
        if (StringUtils.isNotBlank((String)this.customSchema)) {
            authenticationInfo.setDefaultDatabaseName(this.customSchema);
        }
        return authenticationInfo;
    }
}

