/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.utils;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class RegexUtils {
    private static Map<String, Pattern> patterns = null;

    public static String findFirst(String originalStr, String regex) {
        if (StringUtils.isBlank((String)originalStr) || StringUtils.isBlank((String)regex)) {
            return "";
        }
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.contains(originalStr, patterns.get(regex))) {
            return StringUtils.trimToEmpty((String)matcher.getMatch().group(0));
        }
        return "";
    }

    static {
        patterns = OtterMigrateMap.makeSoftValueComputingMap((Function)new Function<String, Pattern>(){

            public Pattern apply(String pattern) {
                try {
                    Perl5Compiler pc = new Perl5Compiler();
                    return pc.compile(pattern, 32769);
                }
                catch (MalformedPatternException e) {
                    throw new ManagerException(e);
                }
            }
        });
    }
}

