/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.utils;

import com.alibaba.otter.manager.biz.common.DataSourceCreator;
import com.alibaba.otter.manager.biz.config.datamediasource.DataMediaSourceService;
import com.alibaba.otter.shared.common.model.config.ConfigHelper;
import com.alibaba.otter.shared.common.model.config.ModeValueFilter;
import com.alibaba.otter.shared.common.model.config.data.DataMedia;
import com.alibaba.otter.shared.common.model.config.data.DataMediaSource;
import com.alibaba.otter.shared.common.model.config.data.DataMediaType;
import com.alibaba.otter.shared.common.model.config.data.db.DbMediaSource;
import com.alibaba.otter.shared.common.utils.meta.DdlSchemaFilter;
import com.alibaba.otter.shared.common.utils.meta.DdlTableNameFilter;
import com.alibaba.otter.shared.common.utils.meta.DdlUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.model.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSourceChecker {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceChecker.class);
    private DataMediaSourceService dataMediaSourceService;
    private DataSourceCreator dataSourceCreator;
    private static final String DATABASE_SUCCESS = "\u606d\u559c,\u6570\u636e\u5e93\u901a\u8fc7\u9a8c\u8bc1!";
    private static final String DATABASE_FAIL = "\u62b1\u6b49,\u6570\u636e\u5e93\u672a\u901a\u8fc7\u9a8c\u8bc1,\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e!";
    private static final String TABLE_SUCCESS = "\u606d\u559c,select\u64cd\u4f5c\u6210\u529f,\u6743\u9650\u6b63\u5e38!";
    private static final String TABLE_FAIL = "\u62b1\u6b49,\u64cd\u4f5c\u62a5\u9519,\u8bf7\u68c0\u67e5\u6743\u9650\u914d\u7f6e!";
    private static final String ENCODE_QUERY_ERROR = "\u6267\u884cSQL\u51fa\u9519,\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u7c7b\u578b\u662f\u5426\u9009\u62e9\u6b63\u786e!";
    private static final String ENCODE_FAIL = "\u62b1\u6b49,\u5b57\u7b26\u96c6\u4e0d\u5339\u914d,\u5b9e\u9645\u6570\u636e\u5e93\u9ed8\u8ba4\u5b57\u7b26\u96c6\u4e3a:";
    private static final String SELECT_FAIL = "SELECT\u672a\u6210\u529f";

    private void closeConnection(Connection conn) {
        this.closeConnection(conn, null, null);
    }

    private void closeConnection(Connection conn, Statement st) {
        this.closeConnection(conn, st, null);
    }

    private void closeConnection(Connection conn, Statement st, ResultSet rs) {
        try {
            if (null != rs) {
                rs.close();
            }
            if (null != st) {
                st.close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            logger.error("", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String check(String url, String username, String password, String encode, String sourceType) {
        DataSource dataSource;
        Connection conn;
        block23: {
            String string;
            block22: {
                String string2;
                block21: {
                    String string3;
                    conn = null;
                    Statement stmt = null;
                    ResultSet rs = null;
                    dataSource = null;
                    try {
                        DbMediaSource dbMediaSource = new DbMediaSource();
                        dbMediaSource.setUrl(url);
                        dbMediaSource.setUsername(username);
                        dbMediaSource.setPassword(password);
                        dbMediaSource.setEncode(encode);
                        if (sourceType.equalsIgnoreCase("MYSQL")) {
                            dbMediaSource.setType(DataMediaType.MYSQL);
                            dbMediaSource.setDriver("com.mysql.jdbc.Driver");
                        } else if (sourceType.equalsIgnoreCase("ORACLE")) {
                            dbMediaSource.setType(DataMediaType.ORACLE);
                            dbMediaSource.setDriver("oracle.jdbc.driver.OracleDriver");
                        }
                        dataSource = this.dataSourceCreator.createDataSource((DataMediaSource)dbMediaSource);
                        try {
                            conn = dataSource.getConnection();
                        }
                        catch (Exception e) {
                            logger.error("check error!", (Throwable)e);
                        }
                        if (null == conn) {
                            String e = DATABASE_FAIL;
                            this.closeConnection(conn);
                            this.dataSourceCreator.destroyDataSource(dataSource);
                            return e;
                        }
                        stmt = conn.createStatement();
                        String sql = null;
                        if (sourceType.equals("MYSQL")) {
                            sql = "SHOW VARIABLES LIKE 'character_set_database'";
                        } else if (sourceType.equals("ORACLE")) {
                            sql = "select * from V$NLS_PARAMETERS where parameter in('NLS_CHARACTERSET')";
                        }
                        rs = stmt.executeQuery(sql);
                        while (rs.next()) {
                            String defaultEncode = null;
                            if (sourceType.equals("MYSQL")) {
                                defaultEncode = ((String)rs.getObject(2)).toLowerCase();
                                String string4 = defaultEncode = defaultEncode.equals("iso-8859-1") ? "latin1" : defaultEncode;
                                if (encode.toLowerCase().equals(defaultEncode)) continue;
                                string2 = ENCODE_FAIL + defaultEncode;
                                this.closeConnection(conn);
                                break block21;
                            }
                            if (!sourceType.equals("ORACLE")) continue;
                            defaultEncode = ((String)rs.getObject(2)).toLowerCase();
                            defaultEncode = defaultEncode.equalsIgnoreCase("zhs16gbk") ? "gbk" : defaultEncode;
                            String string5 = defaultEncode = defaultEncode.equalsIgnoreCase("us7ascii") ? "iso-8859-1" : defaultEncode;
                            if (encode.toLowerCase().equals(defaultEncode)) continue;
                            string = ENCODE_FAIL + defaultEncode;
                            this.closeConnection(conn);
                            break block22;
                        }
                        this.closeConnection(conn);
                        break block23;
                    }
                    catch (SQLException se) {
                        logger.error("check error!", (Throwable)se);
                        string3 = ENCODE_QUERY_ERROR;
                        return string3;
                    }
                    catch (Exception e) {
                        logger.error("check error!", (Throwable)e);
                        string3 = DATABASE_FAIL;
                        return string3;
                    }
                }
                this.dataSourceCreator.destroyDataSource(dataSource);
                return string2;
            }
            this.dataSourceCreator.destroyDataSource(dataSource);
            return string;
        }
        this.dataSourceCreator.destroyDataSource(dataSource);
        return DATABASE_SUCCESS;
        finally {
            this.closeConnection(conn);
            this.dataSourceCreator.destroyDataSource(dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkMap(String namespace, String name, Long dataSourceId) {
        Connection conn = null;
        Statement stmt = null;
        DataMediaSource source = (DataMediaSource)this.dataMediaSourceService.findById(dataSourceId);
        DataSource dataSource = null;
        try {
            DbMediaSource dbMediaSource = (DbMediaSource)source;
            dataSource = this.dataSourceCreator.createDataSource((DataMediaSource)dbMediaSource);
            DataMedia.ModeValue namespaceValue = ConfigHelper.parseMode((String)namespace);
            DataMedia.ModeValue nameValue = ConfigHelper.parseMode((String)name);
            String tempNamespace = namespaceValue.getSingleValue();
            String tempName = nameValue.getSingleValue();
            try {
                Table table = DdlUtils.findTable((JdbcTemplate)new JdbcTemplate(dataSource), (String)tempNamespace, (String)tempNamespace, (String)tempName);
                if (table == null) {
                    String string = SELECT_FAIL;
                    return string;
                }
            }
            catch (SQLException se) {
                logger.error("check error!", (Throwable)se);
                String string = SELECT_FAIL;
                return string;
            }
            catch (Exception e) {
                logger.error("check error!", (Throwable)e);
                String string = SELECT_FAIL;
                this.closeConnection(conn, stmt);
                this.dataSourceCreator.destroyDataSource(dataSource);
                return string;
            }
        }
        finally {
            this.closeConnection(conn, stmt);
            this.dataSourceCreator.destroyDataSource(dataSource);
        }
        return TABLE_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkNamespaceTables(String namespace, String name, Long dataSourceId) {
        String string;
        DataSource dataSource = null;
        try {
            DataMediaSource source = (DataMediaSource)this.dataMediaSourceService.findById(dataSourceId);
            DbMediaSource dbMediaSource = (DbMediaSource)source;
            dataSource = this.dataSourceCreator.createDataSource((DataMediaSource)dbMediaSource);
            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
            DataMedia.ModeValue mode = ConfigHelper.parseMode((String)namespace);
            String schemaPattern = ConfigHelper.makeSQLPattern((DataMedia.ModeValue)mode, (String)namespace);
            final ModeValueFilter modeValueFilter = ConfigHelper.makeModeValueFilter((DataMedia.ModeValue)mode, (String)namespace);
            List schemaList = source.getType().isOracle() ? Arrays.asList(namespace) : DdlUtils.findSchemas((JdbcTemplate)jdbcTemplate, (String)schemaPattern, (DdlSchemaFilter)new DdlSchemaFilter(){

                public boolean accept(String schemaName) {
                    return modeValueFilter.accept(schemaName);
                }
            });
            final ArrayList<String> matchSchemaTables = new ArrayList<String>();
            matchSchemaTables.add("Find schema and tables:");
            if (schemaList != null) {
                DataMedia.ModeValue mode2 = ConfigHelper.parseMode((String)name);
                String tableNamePattern = ConfigHelper.makeSQLPattern((DataMedia.ModeValue)mode2, (String)name);
                final ModeValueFilter modeValueFilter2 = ConfigHelper.makeModeValueFilter((DataMedia.ModeValue)mode2, (String)name);
                for (String schema : schemaList) {
                    DdlUtils.findTables((JdbcTemplate)jdbcTemplate, (String)schema, (String)schema, (String)tableNamePattern, null, (DdlTableNameFilter)new DdlTableNameFilter(){

                        public boolean accept(String catalogName, String schemaName, String tableName) {
                            if (modeValueFilter2.accept(tableName)) {
                                matchSchemaTables.add(schemaName + "." + tableName);
                            }
                            return false;
                        }
                    });
                }
            }
            if (matchSchemaTables.size() == 1) {
                string = TABLE_FAIL;
                this.dataSourceCreator.destroyDataSource(dataSource);
                return string;
            }
            string = StringUtils.join(matchSchemaTables, (String)"<br>\n");
            this.dataSourceCreator.destroyDataSource(dataSource);
        }
        catch (Exception e) {
            logger.error("check error!", (Throwable)e);
            String string2 = TABLE_FAIL;
            return string2;
        }
        finally {
            this.dataSourceCreator.destroyDataSource(dataSource);
        }
        return string;
    }

    public void setDataMediaSourceService(DataMediaSourceService dataMediaSourceService) {
        this.dataMediaSourceService = dataMediaSourceService;
    }

    public void setDataSourceCreator(DataSourceCreator dataSourceCreator) {
        this.dataSourceCreator = dataSourceCreator;
    }
}

