/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.user.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.common.exceptions.RepeatConfigureException;
import com.alibaba.otter.manager.biz.user.UserService;
import com.alibaba.otter.manager.biz.user.dal.UserDAO;
import com.alibaba.otter.manager.biz.user.dal.dataobject.UserDO;
import com.alibaba.otter.shared.common.model.user.User;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceImpl
implements UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserServiceImpl.class);
    private UserDAO userDao;

    @Override
    public void createUser(User user) {
        Assert.assertNotNull((Object)user);
        try {
            UserDO userDo = this.userDao.insertUser(this.modelToDo(user));
            if (userDo.getId() == 0L) {
                String exceptionCause = "exist the same name user in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## create user has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public void deleteUser(Long userId) {
        Assert.assertNotNull((Object)userId);
        this.userDao.deleteUser(userId);
    }

    @Override
    public void updataUser(User user) {
        Assert.assertNotNull((Object)user);
        try {
            UserDO UserDo = this.modelToDo(user);
            if (!this.userDao.chackUnique(UserDo)) {
                String exceptionCause = "exist the same name user in the database.";
                logger.warn("WARN ## " + exceptionCause);
                throw new RepeatConfigureException(exceptionCause);
            }
            this.userDao.updateUser(UserDo);
        }
        catch (RepeatConfigureException rce) {
            throw rce;
        }
        catch (Exception e) {
            logger.error("ERROR ## create user has an exception!");
            throw new ManagerException(e);
        }
    }

    @Override
    public User findUserById(Long userId) {
        Assert.assertNotNull((Object)userId);
        return this.doToModel(this.userDao.findUserById(userId));
    }

    @Override
    public List<User> ListAllUsers() {
        List<UserDO> userDos = this.userDao.listAllUsers();
        ArrayList<User> users = new ArrayList<User>();
        for (UserDO userDo : userDos) {
            users.add(this.doToModel(userDo));
        }
        return users;
    }

    @Override
    public List<User> listByCondition(Map condition) {
        List<UserDO> userDos = this.userDao.listByCondition(condition);
        ArrayList<User> users = new ArrayList<User>();
        for (UserDO userDo : userDos) {
            users.add(this.doToModel(userDo));
        }
        return users;
    }

    @Override
    public int getCount() {
        return this.userDao.getCount();
    }

    @Override
    public int getCount(Map condition) {
        return this.userDao.getCount(condition);
    }

    @Override
    public User login(String name, String password) {
        UserDO userDo = this.userDao.getAuthenticatedUser(name, password);
        if (null == userDo) {
            return null;
        }
        return this.doToModel(userDo);
    }

    private User doToModel(UserDO userDo) {
        User user = new User();
        user.setId(userDo.getId());
        user.setName(userDo.getName());
        user.setDepartment(userDo.getDepartment());
        user.setRealName(userDo.getRealName());
        user.setAuthorizeType(userDo.getAuthorizeType());
        user.setGmtCreate(userDo.getGmtCreate());
        user.setGmtModified(userDo.getGmtModified());
        return user;
    }

    private UserDO modelToDo(User user) {
        UserDO userDo = new UserDO();
        userDo.setId(user.getId());
        userDo.setName(user.getName());
        userDo.setPassword(user.getPassword());
        userDo.setDepartment(user.getDepartment());
        userDo.setRealName(user.getRealName());
        userDo.setAuthorizeType(user.getAuthorizeType());
        userDo.setGmtCreate(user.getGmtCreate());
        userDo.setGmtModified(user.getGmtModified());
        return userDo;
    }

    public UserDAO getUserDao() {
        return this.userDao;
    }

    public void setUserDao(UserDAO userDao) {
        this.userDao = userDao;
    }
}

