/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.user.dal.ibatis;

import com.alibaba.otter.manager.biz.user.dal.UserDAO;
import com.alibaba.otter.manager.biz.user.dal.dataobject.UserDO;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.List;
import java.util.Map;
import org.springframework.orm.ibatis.support.SqlMapClientDaoSupport;

public class IbatisUserDAO
extends SqlMapClientDaoSupport
implements UserDAO {
    @Override
    public UserDO findUserById(Long userId) {
        Assert.assertNotNull((Object)userId);
        return (UserDO)this.getSqlMapClientTemplate().queryForObject("findUserById", (Object)userId);
    }

    @Override
    public List<UserDO> listAllUsers() {
        return this.getSqlMapClientTemplate().queryForList("listUsers");
    }

    @Override
    public List<UserDO> listByCondition(Map condition) {
        return this.getSqlMapClientTemplate().queryForList("listUsers", (Object)condition);
    }

    @Override
    public UserDO insertUser(UserDO user) {
        Assert.assertNotNull((Object)user);
        this.getSqlMapClientTemplate().insert("insertUser", (Object)user);
        return user;
    }

    @Override
    public void updateUser(UserDO user) {
        Assert.assertNotNull((Object)user);
        this.getSqlMapClientTemplate().update("updateUser", (Object)user);
    }

    @Override
    public boolean chackUnique(UserDO user) {
        Assert.assertNotNull((Object)user);
        int count = (Integer)this.getSqlMapClientTemplate().queryForObject("checkUserUnique", (Object)user);
        return count == 0;
    }

    @Override
    public void deleteUser(Long userId) {
        Assert.assertNotNull((Object)userId);
        this.getSqlMapClientTemplate().delete("deleteUserById", (Object)userId);
    }

    @Override
    public UserDO getAuthenticatedUser(String name, String password) {
        UserDO userDo = new UserDO();
        userDo.setName(name);
        userDo.setPassword(password);
        return (UserDO)this.getSqlMapClientTemplate().queryForObject("getUserByNameAndPassword", (Object)userDo);
    }

    @Override
    public int getCount() {
        Integer count = (Integer)this.getSqlMapClientTemplate().queryForObject("getUserCount");
        return count;
    }

    @Override
    public int getCount(Map condition) {
        Integer count = (Integer)this.getSqlMapClientTemplate().queryForObject("getUserCount", (Object)condition);
        return count;
    }
}

