/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.statistics.throughput.param;

import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import java.util.List;

public class ThroughputInfo {
    private Long seconds = 60L;
    private List<ThroughputStat> items;

    public Long getTps() {
        Long tps = 0L;
        if (this.items.size() != 0) {
            for (ThroughputStat item : this.items) {
                if (item.getEndTime().equals(item.getStartTime())) {
                    tps = tps + item.getNumber();
                    continue;
                }
                tps = tps + item.getNumber() * 1000L / (item.getEndTime().getTime() - item.getStartTime().getTime());
            }
            if (this.seconds != 0L) {
                tps = tps / this.seconds;
            }
        }
        return tps;
    }

    public Long getQuantity() {
        Long quantity = 0L;
        if (this.items.size() != 0) {
            for (ThroughputStat item : this.items) {
                if (item.getEndTime().equals(item.getStartTime())) {
                    quantity = quantity + item.getSize();
                    continue;
                }
                quantity = quantity + item.getSize() * 1000L / (item.getEndTime().getTime() - item.getStartTime().getTime());
            }
            if (this.seconds != 0L) {
                quantity = quantity / (long)this.items.size();
            }
        }
        return quantity;
    }

    public Long getNumber() {
        Long number = 0L;
        if (this.items.size() != 0) {
            for (ThroughputStat item : this.items) {
                number = number + item.getNumber();
            }
        }
        return number;
    }

    public Long getSize() {
        Long size = 0L;
        if (this.items.size() != 0) {
            for (ThroughputStat item : this.items) {
                size = size + item.getSize();
            }
        }
        return size;
    }

    public List<ThroughputStat> getItems() {
        return this.items;
    }

    public void setItems(List<ThroughputStat> items) {
        this.items = items;
    }

    public Long getSeconds() {
        return this.seconds;
    }

    public void setSeconds(Long seconds) {
        this.seconds = seconds;
    }
}

