/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.statistics.throughput.impl;

import com.alibaba.otter.manager.biz.statistics.throughput.ThroughputStatService;
import com.alibaba.otter.manager.biz.statistics.throughput.dal.ThroughputDAO;
import com.alibaba.otter.manager.biz.statistics.throughput.dal.dataobject.ThroughputStatDO;
import com.alibaba.otter.manager.biz.statistics.throughput.param.AnalysisType;
import com.alibaba.otter.manager.biz.statistics.throughput.param.RealtimeThroughputCondition;
import com.alibaba.otter.manager.biz.statistics.throughput.param.ThroughputCondition;
import com.alibaba.otter.manager.biz.statistics.throughput.param.ThroughputInfo;
import com.alibaba.otter.manager.biz.statistics.throughput.param.TimelineThroughputCondition;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ThroughputStatServiceImpl
implements ThroughputStatService {
    private ThroughputDAO throughputDao;

    public ThroughputDAO getThroughputDao() {
        return this.throughputDao;
    }

    public void setThroughputDao(ThroughputDAO throughputDao) {
        this.throughputDao = throughputDao;
    }

    @Override
    public void createOrUpdateThroughput(ThroughputStat item) {
        Assert.assertNotNull((Object)item);
        this.throughputDao.insertThroughputStat(this.throughputStatModelToDo(item));
    }

    @Override
    public ThroughputStat findThroughputStatByPipelineId(ThroughputCondition condition) {
        Assert.assertNotNull((Object)condition);
        ThroughputStatDO throughputStatDO = this.throughputDao.findRealtimeThroughputStat(condition);
        ThroughputStat throughputStat = new ThroughputStat();
        if (throughputStatDO != null) {
            throughputStat = this.throughputStatDOToModel(throughputStatDO);
        }
        return throughputStat;
    }

    @Override
    public Map<AnalysisType, ThroughputInfo> listRealtimeThroughput(RealtimeThroughputCondition condition) {
        Assert.assertNotNull((Object)condition);
        HashMap<AnalysisType, ThroughputInfo> throughputInfos = new HashMap<AnalysisType, ThroughputInfo>();
        TimelineThroughputCondition timelineCondition = new TimelineThroughputCondition();
        Date realtime = new Date(System.currentTimeMillis());
        timelineCondition.setPipelineId(condition.getPipelineId());
        timelineCondition.setType(condition.getType());
        timelineCondition.setStart(new Date(realtime.getTime() - (long)(condition.getMax() * 60 * 1000)));
        timelineCondition.setEnd(realtime);
        List<ThroughputStatDO> throughputStatDOs = this.throughputDao.listTimelineThroughputStat(timelineCondition);
        for (AnalysisType analysisType : condition.getAnalysisType()) {
            ThroughputInfo throughputInfo = new ThroughputInfo();
            ArrayList<ThroughputStat> throughputStat = new ArrayList<ThroughputStat>();
            for (ThroughputStatDO throughputStatDO : throughputStatDOs) {
                if (realtime.getTime() - throughputStatDO.getEndTime().getTime() > (long)(analysisType.getValue() * 60 * 1000)) continue;
                throughputStat.add(this.throughputStatDOToModel(throughputStatDO));
            }
            throughputInfo.setItems(throughputStat);
            throughputInfo.setSeconds((long)analysisType.getValue() * 60L);
            throughputInfos.put(analysisType, throughputInfo);
        }
        return throughputInfos;
    }

    @Override
    public Map<Long, ThroughputInfo> listTimelineThroughput(TimelineThroughputCondition condition) {
        Assert.assertNotNull((Object)condition);
        LinkedHashMap<Long, ThroughputInfo> throughputInfos = new LinkedHashMap<Long, ThroughputInfo>();
        List<ThroughputStatDO> throughputStatDOs = this.throughputDao.listTimelineThroughputStat(condition);
        int size = throughputStatDOs.size();
        int k = size - 1;
        Long i = condition.getStart().getTime();
        while (i <= condition.getEnd().getTime()) {
            ThroughputInfo throughputInfo = new ThroughputInfo();
            ArrayList<ThroughputStat> throughputStat = new ArrayList<ThroughputStat>();
            for (int j = k; j >= 0 && i - throughputStatDOs.get(j).getEndTime().getTime() <= 60000L && i - throughputStatDOs.get(j).getEndTime().getTime() >= 0L; --j) {
                throughputStat.add(this.throughputStatDOToModel(throughputStatDOs.get(j)));
                k = j - 1;
            }
            if (throughputStat.size() > 0) {
                throughputInfo.setItems(throughputStat);
                throughputInfo.setSeconds(60L);
                throughputInfos.put(i, throughputInfo);
            }
            i = i + 60000L;
        }
        return throughputInfos;
    }

    @Override
    public List<ThroughputStat> listRealtimeThroughputByPipelineIds(List<Long> pipelineIds, int minute) {
        Assert.assertNotNull(pipelineIds);
        List<ThroughputStatDO> throughputStatDOs = this.throughputDao.listRealTimeThroughputStatByPipelineIds(pipelineIds, minute);
        ArrayList<ThroughputStat> infos = new ArrayList<ThroughputStat>();
        for (ThroughputStatDO throughputStatDO : throughputStatDOs) {
            infos.add(this.throughputStatDOToModel(throughputStatDO));
        }
        return infos;
    }

    private ThroughputStatDO throughputStatModelToDo(ThroughputStat throughputStat) {
        ThroughputStatDO throughputStatDO = new ThroughputStatDO();
        throughputStatDO.setId(throughputStat.getId());
        throughputStatDO.setPipelineId(throughputStat.getPipelineId());
        throughputStatDO.setStartTime(throughputStat.getStartTime());
        throughputStatDO.setEndTime(throughputStat.getEndTime());
        throughputStatDO.setType(throughputStat.getType());
        throughputStatDO.setNumber(throughputStat.getNumber());
        throughputStatDO.setSize(throughputStat.getSize());
        throughputStatDO.setGmtCreate(throughputStat.getGmtCreate());
        throughputStatDO.setGmtModified(throughputStat.getGmtModified());
        return throughputStatDO;
    }

    private ThroughputStat throughputStatDOToModel(ThroughputStatDO throughputStatDO) {
        ThroughputStat throughputStat = new ThroughputStat();
        throughputStat.setId(throughputStatDO.getId());
        throughputStat.setPipelineId(throughputStatDO.getPipelineId());
        throughputStat.setStartTime(throughputStatDO.getStartTime());
        throughputStat.setEndTime(throughputStatDO.getEndTime());
        throughputStat.setType(throughputStatDO.getType());
        throughputStat.setNumber(throughputStatDO.getNumber());
        throughputStat.setSize(throughputStatDO.getSize());
        throughputStat.setGmtCreate(throughputStatDO.getGmtCreate());
        throughputStat.setGmtModified(throughputStatDO.getGmtModified());
        return throughputStat;
    }
}

