/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.statistics.table.impl;

import com.alibaba.otter.manager.biz.statistics.table.TableStatService;
import com.alibaba.otter.manager.biz.statistics.table.dal.TableHistoryStatDAO;
import com.alibaba.otter.manager.biz.statistics.table.dal.TableStatDAO;
import com.alibaba.otter.manager.biz.statistics.table.dal.dataobject.TableHistoryStatDO;
import com.alibaba.otter.manager.biz.statistics.table.dal.dataobject.TableStatDO;
import com.alibaba.otter.manager.biz.statistics.table.param.BehaviorHistoryInfo;
import com.alibaba.otter.manager.biz.statistics.table.param.TimelineBehaviorHistoryCondition;
import com.alibaba.otter.shared.common.model.statistics.table.TableStat;
import com.alibaba.otter.shared.common.utils.Assert;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class TableStatServiceImpl
implements TableStatService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(TableStatServiceImpl.class);
    private TableStatDAO tableStatDao;
    private TableHistoryStatDAO tableHistoryStatDao;
    private Map<Long, TableStat> tableStats = new HashMap<Long, TableStat>();
    private Long statUnit = 60000L;
    private ScheduledThreadPoolExecutor scheduler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTableStat(TableStat stat) {
        Assert.assertNotNull((Object)stat);
        int affect = this.tableStatDao.modifyTableStat(this.tableStatModelToDo(stat));
        if (affect == 0) {
            this.tableStatDao.insertTableStat(this.tableStatModelToDo(stat));
        }
        if (stat.getStartTime() != null && stat.getEndTime() != null) {
            if (this.statUnit <= 0L) {
                this.insertBehaviorHistory(stat);
            } else {
                Map<Long, TableStat> map = this.tableStats;
                synchronized (map) {
                    TableStat old = this.tableStats.get(stat.getDataMediaPairId());
                    if (old != null) {
                        old.setInsertCount(Long.valueOf(stat.getInsertCount() + old.getInsertCount()));
                        old.setUpdateCount(Long.valueOf(stat.getUpdateCount() + old.getUpdateCount()));
                        old.setDeleteCount(Long.valueOf(stat.getDeleteCount() + old.getDeleteCount()));
                        old.setFileCount(Long.valueOf(stat.getFileCount() + old.getFileCount()));
                        old.setFileSize(Long.valueOf(stat.getFileSize() + old.getFileSize()));
                        if (stat.getEndTime().after(old.getEndTime())) {
                            old.setEndTime(stat.getEndTime());
                        }
                        if (stat.getStartTime().before(old.getStartTime())) {
                            old.setStartTime(stat.getStartTime());
                        }
                    } else {
                        this.tableStats.put(stat.getDataMediaPairId(), stat);
                    }
                }
            }
        }
    }

    @Override
    public List<TableStat> listTableStat(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        List<TableStatDO> tableStatDOs = this.tableStatDao.listTableStatsByPipelineId(pipelineId);
        ArrayList<TableStat> tableStats = new ArrayList<TableStat>();
        for (TableStatDO tableStatDO : tableStatDOs) {
            tableStats.add(this.tableStatDOToModel(tableStatDO));
        }
        return tableStats;
    }

    @Override
    public void insertBehaviorHistory(TableStat stat) {
        this.tableHistoryStatDao.insertTableHistoryStat(this.tableHistoryStatModelToDo(stat));
    }

    @Override
    public Map<Long, BehaviorHistoryInfo> listTimelineBehaviorHistory(TimelineBehaviorHistoryCondition condition) {
        Assert.assertNotNull((Object)condition);
        LinkedHashMap<Long, BehaviorHistoryInfo> behaviorHistoryInfos = new LinkedHashMap<Long, BehaviorHistoryInfo>();
        List<TableHistoryStatDO> tableHistoryStatDOs = this.tableHistoryStatDao.listTimelineTableStat(condition);
        int size = tableHistoryStatDOs.size();
        int k = size - 1;
        Long i = condition.getStart().getTime();
        while (i <= condition.getEnd().getTime()) {
            BehaviorHistoryInfo behaviorHistoryInfo = new BehaviorHistoryInfo();
            ArrayList<TableStat> tableStat = new ArrayList<TableStat>();
            for (int j = k; j >= 0 && i - tableHistoryStatDOs.get(j).getEndTime().getTime() <= 60000L && i - tableHistoryStatDOs.get(j).getEndTime().getTime() >= 0L; --j) {
                tableStat.add(this.tableHistoryStatDOToModel(tableHistoryStatDOs.get(j)));
                k = j - 1;
            }
            if (tableStat.size() > 0) {
                behaviorHistoryInfo.setItems(tableStat);
                behaviorHistoryInfos.put(i, behaviorHistoryInfo);
            }
            i = i + 60000L;
        }
        return behaviorHistoryInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBehaviorHistory() {
        Map<Long, TableStat> map = this.tableStats;
        synchronized (map) {
            Collection<TableStat> stats = this.tableStats.values();
            for (TableStat stat : stats) {
                this.insertBehaviorHistory(stat);
            }
            this.tableStats.clear();
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Otter-Statistics-Table"), new ThreadPoolExecutor.CallerRunsPolicy());
        if (this.statUnit > 0L) {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        TableStatServiceImpl.this.flushBehaviorHistory();
                    }
                    catch (Exception e) {
                        logger.error("flush delay stat failed!", (Throwable)e);
                    }
                }
            }, this.statUnit, this.statUnit, TimeUnit.MILLISECONDS);
        }
    }

    private TableStatDO tableStatModelToDo(TableStat tableStat) {
        TableStatDO tableStatDO = new TableStatDO();
        tableStatDO.setId(tableStat.getId());
        tableStatDO.setPipelineId(tableStat.getPipelineId());
        tableStatDO.setDataMediaPairId(tableStat.getDataMediaPairId());
        tableStatDO.setFileSize(tableStat.getFileSize());
        tableStatDO.setFileCount(tableStat.getFileCount());
        tableStatDO.setDeleteCount(tableStat.getDeleteCount());
        tableStatDO.setInsertCount(tableStat.getInsertCount());
        tableStatDO.setUpdateCount(tableStat.getUpdateCount());
        tableStatDO.setGmtCreate(tableStat.getGmtCreate());
        tableStatDO.setGmtModified(tableStat.getGmtModified());
        return tableStatDO;
    }

    private TableStat tableStatDOToModel(TableStatDO tableStatDO) {
        TableStat tableStat = new TableStat();
        tableStat.setId(tableStatDO.getId());
        tableStat.setPipelineId(tableStatDO.getPipelineId());
        tableStat.setDataMediaPairId(tableStatDO.getDataMediaPairId());
        tableStat.setFileSize(tableStatDO.getFileSize());
        tableStat.setFileCount(tableStatDO.getFileCount());
        tableStat.setDeleteCount(tableStatDO.getDeleteCount());
        tableStat.setInsertCount(tableStatDO.getInsertCount());
        tableStat.setUpdateCount(tableStatDO.getUpdateCount());
        tableStat.setGmtCreate(tableStatDO.getGmtCreate());
        tableStat.setGmtModified(tableStatDO.getGmtModified());
        return tableStat;
    }

    private TableHistoryStatDO tableHistoryStatModelToDo(TableStat tableStat) {
        TableHistoryStatDO tableHistoryStatDO = new TableHistoryStatDO();
        tableHistoryStatDO.setId(tableStat.getId());
        tableHistoryStatDO.setPipelineId(tableStat.getPipelineId());
        tableHistoryStatDO.setDataMediaPairId(tableStat.getDataMediaPairId());
        tableHistoryStatDO.setStartTime(tableStat.getStartTime());
        tableHistoryStatDO.setEndTime(tableStat.getEndTime());
        tableHistoryStatDO.setFileSize(tableStat.getFileSize());
        tableHistoryStatDO.setFileCount(tableStat.getFileCount());
        tableHistoryStatDO.setDeleteCount(tableStat.getDeleteCount());
        tableHistoryStatDO.setInsertCount(tableStat.getInsertCount());
        tableHistoryStatDO.setUpdateCount(tableStat.getUpdateCount());
        tableHistoryStatDO.setGmtCreate(tableStat.getGmtCreate());
        tableHistoryStatDO.setGmtModified(tableStat.getGmtModified());
        return tableHistoryStatDO;
    }

    private TableStat tableHistoryStatDOToModel(TableHistoryStatDO tableHistoryStatDO) {
        TableStat tableStat = new TableStat();
        tableStat.setId(tableHistoryStatDO.getId());
        tableStat.setPipelineId(tableHistoryStatDO.getPipelineId());
        tableStat.setDataMediaPairId(tableHistoryStatDO.getDataMediaPairId());
        tableStat.setStartTime(tableHistoryStatDO.getStartTime());
        tableStat.setEndTime(tableHistoryStatDO.getEndTime());
        tableStat.setFileSize(tableHistoryStatDO.getFileSize());
        tableStat.setFileCount(tableHistoryStatDO.getFileCount());
        tableStat.setDeleteCount(tableHistoryStatDO.getDeleteCount());
        tableStat.setInsertCount(tableHistoryStatDO.getInsertCount());
        tableStat.setUpdateCount(tableHistoryStatDO.getUpdateCount());
        tableStat.setGmtCreate(tableHistoryStatDO.getGmtCreate());
        tableStat.setGmtModified(tableHistoryStatDO.getGmtModified());
        return tableStat;
    }

    public void setTableStatDao(TableStatDAO tableStatDao) {
        this.tableStatDao = tableStatDao;
    }

    public void setTableHistoryStatDao(TableHistoryStatDAO tableHistoryStatDao) {
        this.tableHistoryStatDao = tableHistoryStatDao;
    }
}

