/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.statistics.delay.impl;

import com.alibaba.otter.manager.biz.statistics.delay.DelayStatService;
import com.alibaba.otter.manager.biz.statistics.delay.dal.DelayStatDAO;
import com.alibaba.otter.manager.biz.statistics.delay.dal.dataobject.DelayStatDO;
import com.alibaba.otter.manager.biz.statistics.delay.param.DelayStatInfo;
import com.alibaba.otter.manager.biz.statistics.delay.param.TopDelayStat;
import com.alibaba.otter.shared.common.model.statistics.delay.DelayStat;
import com.alibaba.otter.shared.common.utils.Assert;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DelayStatServiceImpl
implements DelayStatService {
    private DelayStatDAO delayStatDao;

    public DelayStatDAO getDelayStatDao() {
        return this.delayStatDao;
    }

    public void setDelayStatDao(DelayStatDAO delayStatDao) {
        this.delayStatDao = delayStatDao;
    }

    @Override
    public void createDelayStat(DelayStat stat) {
        Assert.assertNotNull((Object)stat);
        this.delayStatDao.insertDelayStat(this.delayStatModelToDo(stat));
    }

    @Override
    public DelayStat findRealtimeDelayStat(Long pipelineId) {
        Assert.assertNotNull((Object)pipelineId);
        DelayStatDO delayStatDO = this.delayStatDao.findRealtimeDelayStat(pipelineId);
        DelayStat delayStat = new DelayStat();
        if (delayStatDO != null) {
            delayStat = this.delayStatDOToModel(delayStatDO);
        }
        return delayStat;
    }

    @Override
    public Map<Long, DelayStatInfo> listTimelineDelayStat(Long pipelineId, Date start, Date end) {
        LinkedHashMap<Long, DelayStatInfo> delayStatInfos = new LinkedHashMap<Long, DelayStatInfo>();
        List<DelayStatDO> delayStatDOs = this.delayStatDao.listTimelineDelayStatsByPipelineId(pipelineId, start, end);
        int size = delayStatDOs.size();
        int k = size - 1;
        Long i = start.getTime();
        while (i <= end.getTime()) {
            DelayStatInfo delayStatInfo = new DelayStatInfo();
            ArrayList<DelayStat> delayStats = new ArrayList<DelayStat>();
            for (int j = k; j >= 0 && i - delayStatDOs.get(j).getGmtModified().getTime() <= 60000L && i - delayStatDOs.get(j).getGmtModified().getTime() >= 0L; --j) {
                delayStats.add(this.delayStatDOToModel(delayStatDOs.get(j)));
                k = j - 1;
            }
            if (delayStats.size() > 0) {
                delayStatInfo.setItems(delayStats);
                delayStatInfos.put(i, delayStatInfo);
            }
            i = i + 60000L;
        }
        return delayStatInfos;
    }

    @Override
    public List<TopDelayStat> listTopDelayStat(String searchKey, int topN) {
        return this.delayStatDao.listTopDelayStatsByName(searchKey, topN);
    }

    private DelayStatDO delayStatModelToDo(DelayStat delayStat) {
        DelayStatDO delayStatDO = new DelayStatDO();
        delayStatDO.setId(delayStat.getId());
        delayStatDO.setDelayTime(delayStat.getDelayTime());
        delayStatDO.setDelayNumber(delayStat.getDelayNumber());
        delayStatDO.setPipelineId(delayStat.getPipelineId());
        delayStatDO.setGmtCreate(delayStat.getGmtCreate());
        delayStatDO.setGmtModified(delayStat.getGmtModified());
        return delayStatDO;
    }

    private DelayStat delayStatDOToModel(DelayStatDO delayStatDO) {
        DelayStat delayStat = new DelayStat();
        delayStat.setId(delayStatDO.getId());
        delayStat.setDelayTime(delayStatDO.getDelayTime());
        delayStat.setDelayNumber(delayStatDO.getDelayNumber());
        delayStat.setPipelineId(delayStatDO.getPipelineId());
        delayStat.setGmtCreate(delayStatDO.getGmtCreate());
        delayStat.setGmtModified(delayStatDO.getGmtModified());
        return delayStat;
    }
}

