/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.interceptor;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.shared.communication.model.OtterRemoteException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.dao.DataAccessException;

public class RemoteExceptionLoggerInterceptor
implements ThrowsAdvice {
    private static Logger log = LoggerFactory.getLogger(RemoteExceptionLoggerInterceptor.class);

    public void afterThrowing(Throwable ex) throws Throwable {
        if (log.isErrorEnabled()) {
            log.error("log exception message:", ex);
        }
        String msg = null;
        String stack = null;
        if (ex instanceof ManagerException) {
            msg = ex.getMessage();
            stack = this.getStackTrace(ex);
        } else if (ex instanceof IllegalArgumentException) {
            msg = ex.getMessage();
            stack = this.getStackTrace(ex);
        } else if (ex instanceof DataAccessException) {
            msg = ex.getMessage();
            stack = this.getStackTrace(ex);
        } else if (ex instanceof RuntimeException) {
            msg = ex.getMessage();
            stack = this.getStackTrace(ex);
        }
        throw new OtterRemoteException(msg, stack);
    }

    private String getStackTrace(Throwable ex) {
        StringWriter out = new StringWriter();
        ex.printStackTrace(new PrintWriter(out));
        return out.getBuffer().toString();
    }
}

