/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.impl;

import com.alibaba.otter.manager.biz.remote.StatsRemoteService;
import com.alibaba.otter.manager.biz.statistics.delay.DelayStatService;
import com.alibaba.otter.manager.biz.statistics.table.TableStatService;
import com.alibaba.otter.manager.biz.statistics.throughput.ThroughputStatService;
import com.alibaba.otter.shared.common.model.statistics.delay.DelayCount;
import com.alibaba.otter.shared.common.model.statistics.delay.DelayStat;
import com.alibaba.otter.shared.common.model.statistics.table.TableStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputType;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.statistics.DelayCountEvent;
import com.alibaba.otter.shared.communication.model.statistics.StatisticsEventType;
import com.alibaba.otter.shared.communication.model.statistics.TableStatEvent;
import com.alibaba.otter.shared.communication.model.statistics.ThroughputStatEvent;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StatsRemoteServiceImpl
implements StatsRemoteService {
    private static final Logger logger = LoggerFactory.getLogger(StatsRemoteServiceImpl.class);
    private static final int DEFAULT_POOL = 10;
    private DelayStatService delayStatService;
    private TableStatService tableStatService;
    private ThroughputStatService throughputStatService;
    private Long statUnit = 60000L;
    private ScheduledThreadPoolExecutor scheduler;
    private Map<Long, AvgStat> delayStats;
    private Map<Long, Map<ThroughputType, ThroughputStat>> throughputStats;

    public StatsRemoteServiceImpl() {
        CommunicationRegistry.regist((EventType)StatisticsEventType.delayCount, (Object)this);
        CommunicationRegistry.regist((EventType)StatisticsEventType.tableStat, (Object)this);
        CommunicationRegistry.regist((EventType)StatisticsEventType.throughputStat, (Object)this);
        this.delayStats = OtterMigrateMap.makeComputingMap((Function)new Function<Long, AvgStat>(){

            public AvgStat apply(Long pipelineId) {
                return new AvgStat();
            }
        });
        this.throughputStats = OtterMigrateMap.makeComputingMap((Function)new Function<Long, Map<ThroughputType, ThroughputStat>>(){

            public Map<ThroughputType, ThroughputStat> apply(Long pipelineId) {
                return new HashMap<ThroughputType, ThroughputStat>();
            }
        });
        this.scheduler = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new NamedThreadFactory("Otter-Statistics-Server"), new ThreadPoolExecutor.CallerRunsPolicy());
        if (this.statUnit > 0L) {
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatsRemoteServiceImpl.this.flushDelayStat();
                    }
                    catch (Exception e) {
                        logger.error("flush delay stat failed!", (Throwable)e);
                    }
                }
            }, this.statUnit, this.statUnit, TimeUnit.MILLISECONDS);
            this.scheduler.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatsRemoteServiceImpl.this.flushThroughputStat();
                    }
                    catch (Exception e) {
                        logger.error("flush Throughput stat failed!", (Throwable)e);
                    }
                }
            }, this.statUnit, this.statUnit, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelayCount(DelayCountEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getCount());
        DelayCount count = event.getCount();
        DelayStat stat = new DelayStat();
        stat.setPipelineId(count.getPipelineId());
        stat.setDelayNumber(Long.valueOf(0L));
        stat.setDelayTime(Long.valueOf(count.getTime() >= 0L ? count.getTime() : 0L));
        if (this.statUnit <= 0L) {
            this.delayStatService.createDelayStat(stat);
        } else {
            Map<Long, AvgStat> map = this.delayStats;
            synchronized (map) {
                this.delayStats.get(count.getPipelineId()).merge(stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onThroughputStat(ThroughputStatEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getStats());
        if (this.statUnit <= 0L) {
            for (ThroughputStat stat : event.getStats()) {
                this.throughputStatService.createOrUpdateThroughput(stat);
            }
        } else {
            Map<Long, Map<ThroughputType, ThroughputStat>> map = this.throughputStats;
            synchronized (map) {
                for (ThroughputStat stat : event.getStats()) {
                    Map<ThroughputType, ThroughputStat> data = this.throughputStats.get(stat.getPipelineId());
                    ThroughputStat old = data.get(stat.getType());
                    if (old != null) {
                        old.setNumber(Long.valueOf(stat.getNumber() + old.getNumber()));
                        old.setSize(Long.valueOf(stat.getSize() + old.getSize()));
                        if (stat.getEndTime().after(old.getEndTime())) {
                            old.setEndTime(stat.getEndTime());
                        }
                        if (!stat.getStartTime().before(old.getStartTime())) continue;
                        old.setStartTime(stat.getStartTime());
                        continue;
                    }
                    data.put(stat.getType(), stat);
                }
            }
        }
    }

    @Override
    public void onTableStat(TableStatEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getStats());
        for (TableStat stat : event.getStats()) {
            this.tableStatService.updateTableStat(stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDelayStat() {
        Map<Long, AvgStat> map = this.delayStats;
        synchronized (map) {
            for (Map.Entry<Long, AvgStat> stat : this.delayStats.entrySet()) {
                if (stat.getValue().count.get() <= 0L) continue;
                DelayStat delay = new DelayStat();
                delay.setPipelineId(stat.getKey());
                delay.setDelayTime(stat.getValue().getAvg());
                delay.setDelayNumber(Long.valueOf(0L));
                this.delayStatService.createDelayStat(delay);
            }
            this.delayStats.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushThroughputStat() {
        Map<Long, Map<ThroughputType, ThroughputStat>> map = this.throughputStats;
        synchronized (map) {
            Collection<Map<ThroughputType, ThroughputStat>> stats = this.throughputStats.values();
            for (Map<ThroughputType, ThroughputStat> stat : stats) {
                for (ThroughputStat data : stat.values()) {
                    this.throughputStatService.createOrUpdateThroughput(data);
                }
            }
            this.throughputStats.clear();
        }
    }

    public void setDelayStatService(DelayStatService delayStatService) {
        this.delayStatService = delayStatService;
    }

    public void setTableStatService(TableStatService tableStatService) {
        this.tableStatService = tableStatService;
    }

    public void setThroughputStatService(ThroughputStatService throughputStatService) {
        this.throughputStatService = throughputStatService;
    }

    public static class AvgStat {
        private AtomicLong number = new AtomicLong(0L);
        private AtomicLong count = new AtomicLong(0L);

        public void merge(DelayStat stat) {
            this.count.incrementAndGet();
            this.number.addAndGet(stat.getDelayTime());
        }

        public Long getAvg() {
            if (this.count.get() > 0L) {
                return this.number.get() / this.count.get();
            }
            return 0L;
        }
    }
}

