/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.node.NodeService;
import com.alibaba.otter.manager.biz.remote.NodeRemoteService;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.google.common.base.Function;
import com.google.common.collect.OtterMigrateMap;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class NodeMBeanServiceImpl
implements NodeRemoteService {
    private static final String MBEAN_NAME = "bean:name=otterControllor";
    private static final String SERVICE_URL = "service:jmx:rmi://{0}/jndi/rmi://{0}:{1}/mbean";
    private ObjectName objectName;
    private NodeService nodeService;
    private Map<Long, MBeanServerConnection> mbeanServers;

    public NodeMBeanServiceImpl() {
        try {
            this.objectName = new ObjectName(MBEAN_NAME);
        }
        catch (Exception e) {
            throw new ManagerException(e);
        }
        this.mbeanServers = OtterMigrateMap.makeSoftValueComputingMapWithTimeout((Function)new Function<Long, MBeanServerConnection>(){

            public MBeanServerConnection apply(Long nid) {
                Node node = (Node)NodeMBeanServiceImpl.this.nodeService.findById(nid);
                String ip = node.getIp();
                if (node.getParameters().getUseExternalIp().booleanValue()) {
                    ip = node.getParameters().getExternalIp();
                }
                int port = node.getPort().intValue() + 1;
                Integer mbeanPort = node.getParameters().getMbeanPort();
                if (mbeanPort != null && mbeanPort != 0) {
                    port = mbeanPort;
                }
                try {
                    JMXServiceURL serviceURL = new JMXServiceURL(MessageFormat.format(NodeMBeanServiceImpl.SERVICE_URL, ip, String.valueOf(port)));
                    JMXConnector cntor = JMXConnectorFactory.connect(serviceURL, null);
                    MBeanServerConnection mbsc = cntor.getMBeanServerConnection();
                    return mbsc;
                }
                catch (Exception e) {
                    throw new ManagerException(e);
                }
            }
        }, (long)5L, (TimeUnit)TimeUnit.MINUTES);
    }

    @Override
    public String getHeapMemoryUsage(Long nid) {
        return (String)this.getAttribute(nid, "HeapMemoryUsage");
    }

    @Override
    public String getNodeSystemInfo(Long nid) {
        return (String)this.getAttribute(nid, "NodeSystemInfo");
    }

    @Override
    public String getNodeVersionInfo(Long nid) {
        return (String)this.getAttribute(nid, "NodeVersionInfo");
    }

    @Override
    public int getRunningPipelineCount(Long nid) {
        return (Integer)this.getAttribute(nid, "RunningPipelineCount");
    }

    @Override
    public List<Long> getRunningPipelines(Long nid) {
        return (List)this.getAttribute(nid, "RunningPipelines");
    }

    @Override
    public int getThreadPoolSize(Long nid) {
        return (Integer)this.getAttribute(nid, "ThreadPoolSize");
    }

    @Override
    public void setProfile(Long nid, boolean profile) {
        try {
            this.mbeanServers.get(nid).invoke(this.objectName, "setProfile", new Object[]{profile}, new String[]{"java.lang.Boolean"});
        }
        catch (Exception e) {
            this.mbeanServers.remove(nid);
            throw new ManagerException(e);
        }
    }

    @Override
    public void setThreadPoolSize(Long nid, int size) {
        try {
            this.mbeanServers.get(nid).invoke(this.objectName, "setThreadPoolSize", new Object[]{size}, new String[]{"java.lang.Integer"});
        }
        catch (Exception e) {
            this.mbeanServers.remove(nid);
            throw new ManagerException(e);
        }
    }

    @Override
    public int getThreadActiveSize(Long nid) {
        return (Integer)this.getAttribute(nid, "ThreadActiveSize");
    }

    @Override
    public boolean isSelectRunning(Long nid, Long pipelineId) {
        return (Boolean)this.invoke(nid, pipelineId, "isSelectRunning");
    }

    @Override
    public boolean isExtractRunning(Long nid, Long pipelineId) {
        return (Boolean)this.invoke(nid, pipelineId, "isExtractRunning");
    }

    @Override
    public boolean isTransformRunning(Long nid, Long pipelineId) {
        return (Boolean)this.invoke(nid, pipelineId, "isTransformRunning");
    }

    @Override
    public boolean isLoadRunning(Long nid, Long pipelineId) {
        return (Boolean)this.invoke(nid, pipelineId, "isLoadRunning");
    }

    @Override
    public String selectStageAggregation(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "selectStageAggregation");
    }

    @Override
    public String extractStageAggregation(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "extractStageAggregation");
    }

    @Override
    public String transformStageAggregation(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "transformStageAggregation");
    }

    @Override
    public String loadStageAggregation(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "loadStageAggregation");
    }

    @Override
    public String selectPendingProcess(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "selectPendingProcess");
    }

    @Override
    public String extractPendingProcess(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "extractPendingProcess");
    }

    @Override
    public String transformPendingProcess(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "transformPendingProcess");
    }

    @Override
    public String loadPendingProcess(Long nid, Long pipelineId) {
        return (String)this.invoke(nid, pipelineId, "loadPendingProcess");
    }

    private Object getAttribute(Long nid, String attribute) {
        try {
            return this.mbeanServers.get(nid).getAttribute(this.objectName, attribute);
        }
        catch (Exception e) {
            this.mbeanServers.remove(nid);
            throw new ManagerException(e);
        }
    }

    private Object invoke(Long nid, Long pipelineId, String method) {
        try {
            return this.mbeanServers.get(nid).invoke(this.objectName, method, new Object[]{pipelineId}, new String[]{"java.lang.Long"});
        }
        catch (Exception e) {
            this.mbeanServers.remove(nid);
            throw new ManagerException(e);
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }
}

