/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.impl;

import com.alibaba.otter.manager.biz.common.exceptions.ManagerException;
import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.config.datamatrix.DataMatrixService;
import com.alibaba.otter.manager.biz.config.node.NodeService;
import com.alibaba.otter.manager.biz.remote.ConfigRemoteService;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.data.DataMatrix;
import com.alibaba.otter.shared.common.model.config.node.Node;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.common.utils.JsonUtils;
import com.alibaba.otter.shared.communication.core.CommunicationClient;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.Event;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.config.ConfigEventType;
import com.alibaba.otter.shared.communication.model.config.FindChannelEvent;
import com.alibaba.otter.shared.communication.model.config.FindMediaEvent;
import com.alibaba.otter.shared.communication.model.config.FindNodeEvent;
import com.alibaba.otter.shared.communication.model.config.FindTaskEvent;
import com.alibaba.otter.shared.communication.model.config.NotifyChannelEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ConfigRemoteServiceImpl
implements ConfigRemoteService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRemoteServiceImpl.class);
    private CommunicationClient communicationClient;
    private ChannelService channelService;
    private NodeService nodeService;
    private DataMatrixService dataMatrixService;

    public ConfigRemoteServiceImpl() {
        CommunicationRegistry.regist((EventType)ConfigEventType.findChannel, (Object)this);
        CommunicationRegistry.regist((EventType)ConfigEventType.findNode, (Object)this);
        CommunicationRegistry.regist((EventType)ConfigEventType.findTask, (Object)this);
        CommunicationRegistry.regist((EventType)ConfigEventType.findMedia, (Object)this);
    }

    @Override
    public boolean notifyChannel(Channel channel) {
        Assert.notNull((Object)channel);
        NotifyChannelEvent event = new NotifyChannelEvent();
        event.setChannel(channel);
        HashSet<String> addrsSet = new HashSet<String>();
        for (Pipeline pipeline : channel.getPipelines()) {
            ArrayList nodes = new ArrayList();
            nodes.addAll(pipeline.getSelectNodes());
            nodes.addAll(pipeline.getExtractNodes());
            nodes.addAll(pipeline.getLoadNodes());
            for (Node node : nodes) {
                if (!node.getStatus().isStart() || !StringUtils.isNotEmpty((String)node.getIp()) || node.getPort() == 0L) continue;
                String addr = node.getIp() + ":" + node.getPort();
                if (node.getParameters().getUseExternalIp().booleanValue()) {
                    addr = node.getParameters().getExternalIp() + ":" + node.getPort();
                }
                addrsSet.add(addr);
            }
        }
        ArrayList addrsList = new ArrayList(addrsSet);
        if (CollectionUtils.isEmpty(addrsList) && channel.getStatus().isStart()) {
            throw new ManagerException("no live node for notifyChannel");
        }
        if (CollectionUtils.isEmpty(addrsList)) {
            return true;
        }
        Collections.shuffle(addrsList);
        try {
            String[] addrs = addrsList.toArray(new String[addrsList.size()]);
            List result = (List)this.communicationClient.call(addrs, (Event)event);
            logger.info("## notifyChannel to [{}] channel[{}] result[{}]", new Object[]{ArrayUtils.toString((Object)addrs), channel.toString(), result});
            boolean flag = true;
            for (Boolean f : result) {
                flag &= f.booleanValue();
            }
            return flag;
        }
        catch (Exception e) {
            logger.error("## notifyChannel error!", (Throwable)e);
            throw new ManagerException(e);
        }
    }

    @Override
    public Channel onFindChannel(FindChannelEvent event) {
        Assert.notNull((Object)event);
        Long channelId = event.getChannelId();
        Long pipelineId = event.getPipelineId();
        Channel channel = null;
        if (channelId != null) {
            channel = (Channel)this.channelService.findById(channelId);
        } else {
            Assert.notNull((Object)pipelineId);
            channel = this.channelService.findByPipelineId(pipelineId);
        }
        return channel;
    }

    @Override
    public Node onFindNode(FindNodeEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getNid());
        return (Node)this.nodeService.findById(event.getNid());
    }

    @Override
    public List<Channel> onFindTask(FindTaskEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getNid());
        return this.channelService.listByNodeId(event.getNid(), ChannelStatus.START, ChannelStatus.PAUSE);
    }

    @Override
    public String onFindMedia(FindMediaEvent event) {
        Assert.notNull((Object)event);
        Assert.notNull((Object)event.getDataId());
        DataMatrix matrix = this.dataMatrixService.findByGroupKey(event.getDataId());
        return JsonUtils.marshalToString((Object)matrix);
    }

    public void setCommunicationClient(CommunicationClient communicationClient) {
        this.communicationClient = communicationClient;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDataMatrixService(DataMatrixService dataMatrixService) {
        this.dataMatrixService = dataMatrixService;
    }
}

