/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.impl;

import com.alibaba.otter.canal.instance.manager.model.Canal;
import com.alibaba.otter.canal.instance.manager.model.CanalParameter;
import com.alibaba.otter.manager.biz.config.canal.CanalService;
import com.alibaba.otter.manager.biz.remote.CanalRemoteService;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.canal.CanalEventType;
import com.alibaba.otter.shared.communication.model.canal.FindCanalEvent;
import com.alibaba.otter.shared.communication.model.canal.FindFilterEvent;

public class CanalRemoteServiceImpl
implements CanalRemoteService {
    private CanalService canalService;
    private String tsdbJdbcUrl;
    private String tsdbJdbcUserName;
    private String tsdbJdbcPassword;

    public CanalRemoteServiceImpl() {
        CommunicationRegistry.regist((EventType)CanalEventType.findCanal, (Object)this);
        CommunicationRegistry.regist((EventType)CanalEventType.findFilter, (Object)this);
    }

    @Override
    public Canal onFindCanal(FindCanalEvent event) {
        String destination = event.getDestination();
        Canal canal = this.canalService.findByName(destination);
        CanalParameter parameter = canal.getCanalParameter();
        if (parameter.getTsdbEnable() != null && parameter.getTsdbEnable().booleanValue()) {
            parameter.setTsdbJdbcUrl(this.tsdbJdbcUrl);
            parameter.setTsdbJdbcUserName(this.tsdbJdbcUserName);
            parameter.setTsdbJdbcPassword(this.tsdbJdbcPassword);
        }
        return canal;
    }

    @Override
    public String onFindFilter(FindFilterEvent event) {
        return ".*\\..*";
    }

    public void setCanalService(CanalService canalService) {
        this.canalService = canalService;
    }

    public void setTsdbJdbcUrl(String tsdbJdbcUrl) {
        this.tsdbJdbcUrl = tsdbJdbcUrl;
    }

    public void setTsdbJdbcUserName(String tsdbJdbcUserName) {
        this.tsdbJdbcUserName = tsdbJdbcUserName;
    }

    public void setTsdbJdbcPassword(String tsdbJdbcPassword) {
        this.tsdbJdbcPassword = tsdbJdbcPassword;
    }
}

