/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.remote.impl;

import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.monitor.PassiveMonitor;
import com.alibaba.otter.manager.biz.remote.ArbitrateRemoteService;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.config.channel.Channel;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.communication.core.CommunicationRegistry;
import com.alibaba.otter.shared.communication.core.model.EventType;
import com.alibaba.otter.shared.communication.model.arbitrate.ArbitrateEventType;
import com.alibaba.otter.shared.communication.model.arbitrate.NodeAlarmEvent;
import com.alibaba.otter.shared.communication.model.arbitrate.StopChannelEvent;
import com.alibaba.otter.shared.communication.model.arbitrate.StopNodeEvent;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ArbitrateRemoteServiceImpl
implements ArbitrateRemoteService {
    private static final Logger logger = LoggerFactory.getLogger(ArbitrateRemoteServiceImpl.class);
    private ArbitrateManageService arbitrateManageService;
    private ChannelService channelService;
    private PassiveMonitor exceptionRuleMonitor;

    public ArbitrateRemoteServiceImpl() {
        CommunicationRegistry.regist((EventType)ArbitrateEventType.nodeAlarm, (Object)this);
        CommunicationRegistry.regist((EventType)ArbitrateEventType.stopChannel, (Object)this);
        CommunicationRegistry.regist((EventType)ArbitrateEventType.stopNode, (Object)this);
    }

    @Override
    public void onNodeAlarm(NodeAlarmEvent event) {
        try {
            this.exceptionRuleMonitor.feed((Object)event, event.getPipelineId());
        }
        catch (Exception e) {
            logger.error(String.format("ERROR # exceptionRuleMonitor error for  %s", event.toString()), (Throwable)e);
        }
    }

    @Override
    public void onStopChannel(StopChannelEvent event) {
        this.channelService.stopChannel(event.getChannelId());
    }

    @Override
    public void onStopNode(StopNodeEvent event) {
        Assert.notNull((Object)event);
        List<Channel> channels = this.channelService.listByNodeId(event.getNid(), ChannelStatus.START);
        for (Channel channel : channels) {
            boolean result = this.arbitrateManageService.channelEvent().restart(channel.getId());
            if (!result) continue;
            this.channelService.notifyChannel(channel.getId());
        }
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setExceptionRuleMonitor(PassiveMonitor exceptionRuleMonitor) {
        this.exceptionRuleMonitor = exceptionRuleMonitor;
    }
}

