/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.monitor.Monitor;
import com.alibaba.otter.manager.biz.monitor.impl.GlobalMonitor;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SelfMonitor
implements Monitor,
InitializingBean,
DisposableBean {
    protected static final Logger log = LoggerFactory.getLogger((String)"monitorInfo");
    private static final int DEFAULT_POOL = 1;
    private ScheduledExecutorService executor;
    private ScheduledFuture future;
    private GlobalMonitor monitor;
    private AtomicBoolean enable = new AtomicBoolean(true);
    private int interval = 120;

    @Override
    public void explore() {
        this.monitor.explore();
    }

    @Override
    public void explore(Long ... pipelineIds) {
        this.monitor.explore(pipelineIds);
    }

    @Override
    public void explore(List<AlarmRule> rules) {
        this.monitor.explore(rules);
    }

    public void destroy() throws Exception {
        if (this.enable.get()) {
            this.stop();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.enable.get()) {
            this.start();
        }
    }

    private synchronized void start() {
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("Self-Monitor"), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        if (this.future == null) {
            this.future = this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        SelfMonitor.this.monitor.explore();
                    }
                    catch (Exception e) {
                        log.error("self-monitor failed.", (Throwable)e);
                    }
                }
            }, this.interval, this.interval, TimeUnit.SECONDS);
        }
    }

    private synchronized void stop() {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.executor != null) {
            try {
                this.executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setMonitor(GlobalMonitor monitor) {
        this.monitor = monitor;
    }

    public void setEnable(boolean enable) {
        this.enable.set(enable);
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }
}

