/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.config.pipeline.PipelineService;
import com.alibaba.otter.manager.biz.monitor.AlarmRecovery;
import com.alibaba.otter.manager.biz.monitor.PassiveMonitor;
import com.alibaba.otter.manager.biz.monitor.impl.AlarmRecoveryDelayed;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import com.alibaba.otter.shared.communication.model.arbitrate.NodeAlarmEvent;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RestartAlarmRecovery
implements AlarmRecovery,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(RestartAlarmRecovery.class);
    private volatile DelayQueue<AlarmRecoveryDelayed> queue = new DelayQueue();
    private long checkTime = 10000L;
    private ExecutorService executor;
    private PipelineService pipelineService;
    private PassiveMonitor exceptionRuleMonitor;
    private ArbitrateManageService arbitrateManageService;
    private ChannelService channelService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recovery(Long channelId) {
        AlarmRecoveryDelayed delayed = new AlarmRecoveryDelayed(channelId, -1L, false, this.checkTime);
        DelayQueue<AlarmRecoveryDelayed> delayQueue = this.queue;
        synchronized (delayQueue) {
            if (!this.queue.contains(delayed)) {
                this.queue.add(delayed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recovery(AlarmRule alarmRule) {
        Pipeline pipeline = (Pipeline)this.pipelineService.findById(alarmRule.getPipelineId());
        AlarmRecoveryDelayed delayed = new AlarmRecoveryDelayed(pipeline.getChannelId(), alarmRule.getId(), false, this.checkTime);
        DelayQueue<AlarmRecoveryDelayed> delayQueue = this.queue;
        synchronized (delayQueue) {
            if (!this.queue.contains(delayed)) {
                this.queue.add(delayed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recovery(AlarmRule alarmRule, long alarmCount) {
        if (alarmCount >= (long)alarmRule.getRecoveryThresold().intValue()) {
            DelayQueue<AlarmRecoveryDelayed> delayQueue = this.queue;
            synchronized (delayQueue) {
                Pipeline pipeline = (Pipeline)this.pipelineService.findById(alarmRule.getPipelineId());
                boolean needStop = alarmCount >= (long)(alarmRule.getRecoveryThresold() + 1);
                AlarmRecoveryDelayed delayed = new AlarmRecoveryDelayed(pipeline.getChannelId(), alarmRule.getId(), needStop, this.checkTime);
                if (!this.queue.contains(delayed)) {
                    this.queue.add(delayed);
                }
            }
        }
    }

    private boolean processRecovery(Long channelId, Long ruleId, boolean needStop) {
        boolean result = true;
        if (!needStop) {
            result = this.arbitrateManageService.channelEvent().restart(channelId);
            if (result) {
                this.channelService.notifyChannel(channelId);
            }
        } else {
            this.channelService.stopChannel(channelId);
            this.channelService.startChannel(channelId);
        }
        NodeAlarmEvent alarm = new NodeAlarmEvent();
        alarm.setPipelineId(Long.valueOf(-1L));
        alarm.setTitle(MonitorName.EXCEPTION.name());
        if (result) {
            if (!needStop) {
                alarm.setMessage(String.format("cid:%s restart recovery successful for rid:%s", String.valueOf(channelId), String.valueOf(ruleId)));
            } else {
                alarm.setMessage(String.format("cid:%s stop recovery successful for rid:%s", String.valueOf(channelId), String.valueOf(ruleId)));
            }
            try {
                this.exceptionRuleMonitor.feed((Object)alarm, alarm.getPipelineId());
            }
            catch (Exception e) {
                logger.error(String.format("ERROR # exceptionRuleMonitor error for %s", alarm.toString()), (Throwable)e);
            }
        }
        return result;
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = Executors.newFixedThreadPool(1);
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    AlarmRecoveryDelayed delay = null;
                    try {
                        delay = (AlarmRecoveryDelayed)RestartAlarmRecovery.this.queue.take();
                        RestartAlarmRecovery.this.processRecovery(delay.getChannelId(), delay.getRuleId(), delay.isStop());
                        continue;
                    }
                    catch (Throwable e) {
                        if (!RestartAlarmRecovery.this.queue.contains(delay)) {
                            RestartAlarmRecovery.this.queue.add(delay);
                        }
                        logger.error(String.format("error happened with [%s]", delay.toString()), e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public void destroy() throws Exception {
        this.executor.shutdownNow();
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setPipelineService(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }

    public void setExceptionRuleMonitor(PassiveMonitor exceptionRuleMonitor) {
        this.exceptionRuleMonitor = exceptionRuleMonitor;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }
}

