/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.monitor.MonitorRuleExplorerRegisty;
import com.alibaba.otter.manager.biz.monitor.impl.AbstractRuleMonitor;
import com.alibaba.otter.manager.biz.statistics.stage.ProcessStatService;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.statistics.stage.ProcessStat;
import com.alibaba.otter.shared.common.model.statistics.stage.StageStat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class ProcessTimeoutRuleMonitor
extends AbstractRuleMonitor {
    private static final String TIME_OUT_MESSAGE = "pid:%s processIds:%s elapsed %s seconds";
    @Resource(name="processStatService")
    private ProcessStatService processStatService;

    ProcessTimeoutRuleMonitor() {
        MonitorRuleExplorerRegisty.register(MonitorName.PIPELINETIMEOUT, this);
    }

    @Override
    public void explore(List<AlarmRule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        Long pipelineId = rules.get(0).getPipelineId();
        List<ProcessStat> processStats = this.processStatService.listRealtimeProcessStat(pipelineId);
        if (CollectionUtils.isEmpty(processStats)) {
            return;
        }
        long now = System.currentTimeMillis();
        HashMap<Long, Long> processTime = new HashMap<Long, Long>();
        for (ProcessStat processStat : processStats) {
            Long timeout = 0L;
            if (!CollectionUtils.isEmpty((Collection)processStat.getStageStats())) {
                timeout = now - ((StageStat)processStat.getStageStats().get(0)).getStartTime();
            }
            processTime.put(processStat.getProcessId(), timeout);
        }
        String message = "";
        for (AlarmRule rule : rules) {
            if (message.isEmpty()) {
                message = this.checkTimeout(rule, processTime);
                continue;
            }
            this.checkTimeout(rule, processTime);
        }
        if (!message.isEmpty()) {
            this.logRecordAlarm(pipelineId, MonitorName.PROCESSTIMEOUT, message);
        }
    }

    private String checkTimeout(AlarmRule rule, Map<Long, Long> processTime) {
        if (!this.inPeriod(rule)) {
            return "";
        }
        String matchValue = rule.getMatchValue();
        matchValue = StringUtils.substringBeforeLast((String)matchValue, (String)"@");
        Long maxSpentTime = Long.parseLong(StringUtils.trim((String)matchValue));
        LinkedList<Long> timeoutProcessIds = new LinkedList<Long>();
        Collections.sort(timeoutProcessIds);
        long maxSpent = 0L;
        for (Map.Entry<Long, Long> entry : processTime.entrySet()) {
            if (entry.getValue() < maxSpentTime * 1000L) continue;
            timeoutProcessIds.add(entry.getKey());
            maxSpent = maxSpent > entry.getValue() ? maxSpent : entry.getValue();
        }
        if (CollectionUtils.isEmpty(timeoutProcessIds)) {
            return "";
        }
        String processIds = StringUtils.join(timeoutProcessIds, (String)",");
        String message = String.format(TIME_OUT_MESSAGE, rule.getPipelineId(), processIds, maxSpent / 1000L);
        this.sendAlarm(rule, message);
        return message;
    }
}

