/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.config.pipeline.PipelineService;
import com.alibaba.otter.manager.biz.monitor.MonitorRuleExplorerRegisty;
import com.alibaba.otter.manager.biz.monitor.impl.AbstractRuleMonitor;
import com.alibaba.otter.shared.arbitrate.ArbitrateViewService;
import com.alibaba.otter.shared.arbitrate.model.PositionEventData;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class PositionTimeoutRuleMonitor
extends AbstractRuleMonitor {
    private PipelineService pipelineService;
    private ArbitrateViewService arbitrateViewService;
    private static final String TIME_OUT_MESSAGE = "pid:%s position %s seconds no update";

    PositionTimeoutRuleMonitor() {
        MonitorRuleExplorerRegisty.register(MonitorName.POSITIONTIMEOUT, this);
    }

    @Override
    public void explore(List<AlarmRule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        Long pipelineId = rules.get(0).getPipelineId();
        Pipeline pipeline = (Pipeline)this.pipelineService.findById(pipelineId);
        PositionEventData data = this.arbitrateViewService.getCanalCursor(pipeline.getParameters().getDestinationName(), pipeline.getParameters().getMainstemClientId().shortValue());
        long latestSyncTime = 0L;
        if (data == null || data.getModifiedTime() == null) {
            return;
        }
        Date modifiedDate = data.getModifiedTime();
        latestSyncTime = modifiedDate.getTime();
        long now = System.currentTimeMillis();
        long elapsed = now - latestSyncTime;
        boolean flag = false;
        for (AlarmRule rule : rules) {
            flag |= this.checkTimeout(rule, elapsed);
        }
        if (flag) {
            this.logRecordAlarm(pipelineId, MonitorName.POSITIONTIMEOUT, String.format(TIME_OUT_MESSAGE, pipelineId, elapsed / 1000L));
        }
    }

    private boolean checkTimeout(AlarmRule rule, long elapsed) {
        if (!this.inPeriod(rule)) {
            return false;
        }
        String matchValue = rule.getMatchValue();
        Long maxSpentTime = Long.parseLong(StringUtils.trim((String)(matchValue = StringUtils.substringBeforeLast((String)matchValue, (String)"@"))));
        if (elapsed >= maxSpentTime * 1000L) {
            this.sendAlarm(rule, String.format(TIME_OUT_MESSAGE, rule.getPipelineId(), elapsed / 1000L));
            return true;
        }
        return false;
    }

    public void setPipelineService(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }

    public void setArbitrateViewService(ArbitrateViewService arbitrateViewService) {
        this.arbitrateViewService = arbitrateViewService;
    }
}

