/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.monitor.MonitorRuleExplorerRegisty;
import com.alibaba.otter.manager.biz.monitor.impl.AbstractRuleMonitor;
import com.alibaba.otter.manager.biz.statistics.throughput.ThroughputStatService;
import com.alibaba.otter.manager.biz.statistics.throughput.param.ThroughputCondition;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.MonitorName;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputStat;
import com.alibaba.otter.shared.common.model.statistics.throughput.ThroughputType;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.CollectionUtils;

public class PipelineTimeoutRuleMonitor
extends AbstractRuleMonitor {
    private static final String TIME_OUT_MESSAGE = "pid:%s elapsed %s seconds no sync";
    @Resource(name="throughputStatService")
    private ThroughputStatService throughputStatService;

    PipelineTimeoutRuleMonitor() {
        MonitorRuleExplorerRegisty.register(MonitorName.PIPELINETIMEOUT, this);
    }

    @Override
    public void explore(List<AlarmRule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            return;
        }
        Long pipelineId = rules.get(0).getPipelineId();
        ThroughputCondition condition = new ThroughputCondition();
        condition.setPipelineId(pipelineId);
        condition.setType(ThroughputType.ROW);
        ThroughputStat stat = this.throughputStatService.findThroughputStatByPipelineId(condition);
        long latestSyncTime = 0L;
        if (stat != null && stat.getGmtModified() != null) {
            Date modifiedDate = stat.getGmtModified();
            latestSyncTime = modifiedDate.getTime();
        }
        long now = System.currentTimeMillis();
        long elapsed = now - latestSyncTime;
        boolean flag = false;
        for (AlarmRule rule : rules) {
            flag |= this.checkTimeout(rule, elapsed);
        }
        if (flag) {
            this.logRecordAlarm(pipelineId, MonitorName.PIPELINETIMEOUT, String.format(TIME_OUT_MESSAGE, pipelineId, elapsed / 1000L));
        }
    }

    private boolean checkTimeout(AlarmRule rule, long elapsed) {
        if (!this.inPeriod(rule)) {
            return false;
        }
        String matchValue = rule.getMatchValue();
        Long maxSpentTime = Long.parseLong(StringUtils.trim((String)(matchValue = StringUtils.substringBeforeLast((String)matchValue, (String)"@"))));
        if (elapsed >= maxSpentTime * 1000L) {
            this.sendAlarm(rule, String.format(TIME_OUT_MESSAGE, rule.getPipelineId(), elapsed / 1000L));
            return true;
        }
        return false;
    }
}

