/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.config.pipeline.PipelineService;
import com.alibaba.otter.manager.biz.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.model.config.pipeline.Pipeline;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;

public class PipelineMonitor
implements Monitor {
    @Resource(name="delayStatRuleMonitor")
    private Monitor delayStatRuleMonitor;
    @Resource(name="pipelineTimeoutRuleMonitor")
    private Monitor pipelineTimeoutRuleMonitor;
    @Resource(name="processTimeoutRuleMonitor")
    private Monitor processTimeoutRuleMonitor;
    @Resource(name="positionTimeoutRuleMonitor")
    private Monitor positionTimeoutRuleMonitor;
    @Resource(name="pipelineService")
    private PipelineService pipelineService;
    @Resource(name="arbitrateManageService")
    private ArbitrateManageService arbitrateManageService;

    @Override
    public void explore(List<AlarmRule> rules) {
        Long pipelineId = rules.get(0).getPipelineId();
        Pipeline pipeline = (Pipeline)this.pipelineService.findById(pipelineId);
        ChannelStatus status = this.arbitrateManageService.channelEvent().status(pipeline.getChannelId());
        if (status == null || status.isStop()) {
            return;
        }
        LinkedList<AlarmRule> delayTimeRules = new LinkedList<AlarmRule>();
        LinkedList<AlarmRule> exceptonRules = new LinkedList<AlarmRule>();
        LinkedList<AlarmRule> pipelineTimeoutRules = new LinkedList<AlarmRule>();
        LinkedList<AlarmRule> processTimeoutRules = new LinkedList<AlarmRule>();
        LinkedList<AlarmRule> positionTimeoutRules = new LinkedList<AlarmRule>();
        Date now = new Date();
        for (AlarmRule rule : rules) {
            switch (rule.getMonitorName()) {
                case DELAYTIME: {
                    if (!this.checkEnable(rule, now)) break;
                    delayTimeRules.add(rule);
                    break;
                }
                case EXCEPTION: {
                    if (!this.checkEnable(rule, now)) break;
                    exceptonRules.add(rule);
                    break;
                }
                case PIPELINETIMEOUT: {
                    if (!this.checkEnable(rule, now)) break;
                    pipelineTimeoutRules.add(rule);
                    break;
                }
                case PROCESSTIMEOUT: {
                    if (!this.checkEnable(rule, now)) break;
                    processTimeoutRules.add(rule);
                    break;
                }
                case POSITIONTIMEOUT: {
                    if (!this.checkEnable(rule, now)) break;
                    positionTimeoutRules.add(rule);
                    break;
                }
            }
        }
        if (!delayTimeRules.isEmpty()) {
            this.delayStatRuleMonitor.explore(delayTimeRules);
        }
        if (!pipelineTimeoutRules.isEmpty()) {
            this.pipelineTimeoutRuleMonitor.explore(pipelineTimeoutRules);
        }
        if (!processTimeoutRules.isEmpty()) {
            this.processTimeoutRuleMonitor.explore(processTimeoutRules);
        }
        if (!positionTimeoutRules.isEmpty()) {
            this.positionTimeoutRuleMonitor.explore(positionTimeoutRules);
        }
    }

    private boolean checkEnable(AlarmRule rule, Date now) {
        return rule.getPauseTime() == null || rule.getPauseTime().before(now);
    }

    @Override
    public void explore() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void explore(Long ... pipelineIds) {
        throw new UnsupportedOperationException();
    }
}

