/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.manager.biz.monitor.impl;

import com.alibaba.otter.manager.biz.config.alarm.AlarmRuleService;
import com.alibaba.otter.manager.biz.config.channel.ChannelService;
import com.alibaba.otter.manager.biz.monitor.AlarmRecovery;
import com.alibaba.otter.manager.biz.monitor.Monitor;
import com.alibaba.otter.shared.arbitrate.ArbitrateManageService;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRule;
import com.alibaba.otter.shared.common.model.config.alarm.AlarmRuleStatus;
import com.alibaba.otter.shared.common.model.config.channel.ChannelStatus;
import com.alibaba.otter.shared.common.utils.thread.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class GlobalMonitor
implements Monitor,
InitializingBean,
DisposableBean {
    protected static final Logger log = LoggerFactory.getLogger((String)"monitorInfo");
    private static final int DEFAULT_THREADS = 5;
    private int nThreads;
    private boolean needConcurrent = true;
    private boolean recoveryPaused = true;
    private ExecutorService executor;
    private AlarmRuleService alarmRuleService;
    private Monitor pipelineMonitor;
    private ChannelService channelService;
    private ArbitrateManageService arbitrateManageService;
    private AlarmRecovery restartAlarmRecovery;

    @Override
    public void explore() {
        Map<Long, List<AlarmRule>> rules = this.alarmRuleService.getAlarmRules(AlarmRuleStatus.ENABLE);
        if (!CollectionUtils.isEmpty(rules)) {
            if (this.needConcurrent) {
                this.concurrentProcess(rules);
            } else {
                this.serialProcess(rules);
            }
        } else {
            log.warn("no enabled alarm rule at all. Check the rule setting please!");
        }
        if (this.recoveryPaused) {
            List<Long> channelIds = this.channelService.listAllChannelId();
            if (this.needConcurrent) {
                this.concurrentProcess(channelIds);
            } else {
                this.serialProcess(channelIds);
            }
        }
    }

    private void concurrentProcess(Map<Long, List<AlarmRule>> rules) {
        ExecutorCompletionService<Object> completionExecutor = new ExecutorCompletionService<Object>(this.executor);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (Map.Entry<Long, List<AlarmRule>> entry : rules.entrySet()) {
            final List<AlarmRule> alarmRules = entry.getValue();
            futures.add(completionExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    GlobalMonitor.this.pipelineMonitor.explore(alarmRules);
                    return null;
                }
            }));
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        int size = futures.size();
        for (int index = 0; index < size; ++index) {
            try {
                Future future = completionExecutor.take();
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                exceptions.add(e);
                continue;
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder(exceptions.size() + " exception happens in global monitor\n");
            sb.append("exception stack start :\n");
            for (Throwable throwable : exceptions) {
                sb.append(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
            sb.append("exception stack end \n");
            throw new IllegalStateException(sb.toString());
        }
    }

    private void serialProcess(Map<Long, List<AlarmRule>> rules) {
        for (Map.Entry<Long, List<AlarmRule>> entry : rules.entrySet()) {
            List<AlarmRule> alarmRules = entry.getValue();
            this.pipelineMonitor.explore(alarmRules);
        }
    }

    private void concurrentProcess(List<Long> channelIds) {
        ExecutorCompletionService<Object> completionExecutor = new ExecutorCompletionService<Object>(this.executor);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (final Long channelId : channelIds) {
            futures.add(completionExecutor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ChannelStatus status = GlobalMonitor.this.arbitrateManageService.channelEvent().status(channelId);
                    if (status.isPause()) {
                        GlobalMonitor.this.restartAlarmRecovery.recovery(channelId);
                    }
                    return null;
                }
            }));
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        int size = futures.size();
        for (int index = 0; index < size; ++index) {
            try {
                Future future = completionExecutor.take();
                future.get();
                continue;
            }
            catch (InterruptedException e) {
                exceptions.add(e);
                continue;
            }
            catch (ExecutionException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder sb = new StringBuilder(exceptions.size() + " exception happens in global monitor\n");
            sb.append("exception stack start :\n");
            for (Throwable throwable : exceptions) {
                sb.append(ExceptionUtils.getStackTrace((Throwable)throwable));
            }
            sb.append("exception stack end \n");
            throw new IllegalStateException(sb.toString());
        }
    }

    private void serialProcess(List<Long> channelIds) {
        for (Long channelId : channelIds) {
            ChannelStatus status = this.arbitrateManageService.channelEvent().status(channelId);
            if (!status.isPause()) continue;
            this.restartAlarmRecovery.recovery(channelId);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.nThreads = this.nThreads <= 0 ? 5 : this.nThreads;
        this.executor = new ThreadPoolExecutor(this.nThreads, this.nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.nThreads * 2), (ThreadFactory)new NamedThreadFactory("global monitor", false), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void destroy() throws Exception {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    @Override
    public void explore(Long ... pipelineIds) {
        throw new UnsupportedOperationException("doesn't support right now");
    }

    @Override
    public void explore(List<AlarmRule> rules) {
        throw new UnsupportedOperationException("doesn't support right now");
    }

    public void setnThreads(int nThreads) {
        this.nThreads = nThreads;
    }

    public void setNeedConcurrent(boolean needConcurrent) {
        this.needConcurrent = needConcurrent;
    }

    public void setAlarmRuleService(AlarmRuleService alarmRuleService) {
        this.alarmRuleService = alarmRuleService;
    }

    public void setPipelineMonitor(Monitor pipelineMonitor) {
        this.pipelineMonitor = pipelineMonitor;
    }

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public void setArbitrateManageService(ArbitrateManageService arbitrateManageService) {
        this.arbitrateManageService = arbitrateManageService;
    }

    public void setRestartAlarmRecovery(AlarmRecovery restartAlarmRecovery) {
        this.restartAlarmRecovery = restartAlarmRecovery;
    }

    public void setRecoveryPaused(boolean recoveryPaused) {
        this.recoveryPaused = recoveryPaused;
    }
}

